jls.loader.provide('jls.win32.EditElement');

jls.loader.require('jls.win32.WindowElement');
jls.loader.require('jls.win32.Edit');

jls.win32.EditElement = jls.lang.Class.create(jls.win32.WindowElement,
{
    initialize : function($super, parameters, parent) {
        this._text = '';
        this._readonly = false;
        this._password = false;
        $super(parameters, parent);
    },
    onCreate : function() {
        this._window = new jls.win32.Edit(this.getText(), this.getWindowStyle(),
                this.getX(), this.getY(), this.getW(), this.getH(),
                this.getParentWindow(true), this.getWindowId(true), this.getWindowExStyle());
    },
    getWindowStyle : function($super) {
    	var style = $super();
    	if (this.getStyle().getPropertyValue('border') != null) {
    		style |= jls.win32.Window.WS_BORDER;
    	}
        // TODO Fix
    	//if (this.getStyle().getPropertyValue('overflow') == 'auto') {
    		style |= jls.win32.Edit.ES_AUTOVSCROLL | jls.win32.Edit.ES_AUTOHSCROLL;
    	//}
    	if (this._password) {
    		style |= jls.win32.Edit.ES_PASSWORD;
    	}
    	if (this._readonly) {
    		style |= jls.win32.Edit.ES_READONLY;
    	}
        return style;
    },
    setSelection : function(start, end) {
        this._window.setSelection(start, end);
    },
    replaceSelection : function(text) {
        this._window.replaceSelection(text);
    },
    replaceLastLine : function(text) {
        this._window.replaceLastLine(text);
    },
    appendText : function(text) {
        this._window.appendText(text);
    },
    getReadonly : function() {
        return this._readonly;
    },
    setReadonly : function(value) {
        this._readonly = value;
        return this;
    },
    getPassword : function() {
        return this._password;
    },
    setPassword : function(value) {
        this._password = value;
        return this;
    },
    getText : function() {
        if (this._window != null) {
            this._text = this._window.getText();
        }
        return this._text;
    },
    setText : function(value) {
        if (this._window != null) {
            this._window.setText(value);
        }
        this._text = value;
        return this;
    }
});

