jls.loader.provide('jls.win32.Frame');

jls.loader.require('jls.win32.WindowElement');
jls.loader.require('jls.gui.FlowLayout');

jls.win32.Frame = jls.lang.Class.create(jls.win32.WindowElement,
{
    initialize : function($super, parameters, parent) {
    	this._title = null;
        $super(parameters, parent);
        this._windowId = 0;
        this._childSize = this.getStyle().getPropertyValue('childSize');
        if (this._childSize == null) {
        	this._childSize = 'auto';
        }
        if (this._childSize == 'auto') {
            this.observe('resize', this.onResize.bind(this));
        }
        this.setBounds(this._getBounds());
        
        this._window.show(this.getStyle().getPropertyValue('visibility') == 'visible' ? jls.win32.Window.SW_SHOW : jls.win32.Window.SW_HIDE);
        this._window.update();
    },
    onCreate : function() {
    	var x = (this.getX() != null) ? this.getX() : jls.win32.Window.CW_USEDEFAULT;
    	var y = (this.getY() != null) ? this.getY() : jls.win32.Window.CW_USEDEFAULT;
    	var w = (this.getW() != null) ? this.getW() : jls.win32.Window.CW_USEDEFAULT;
    	var h = (this.getH() != null) ? this.getH() : jls.win32.Window.CW_USEDEFAULT;
        this._window = new jls.win32.Window(jls.win32.Frame.classname, this.getTitle(), this.getWindowStyle(),
        		x, y, w, h,
                this.getParentWindow(true), this.getWindowId(), this.getWindowExStyle());
    },
    createDefaultLayout : function() {
        return new jls.gui.FlowLayout(this);
    },
    onResize : function(event) {
        jls.logger.debug('Frame resized to ' + event.width + 'x' + event.height);
        this.setBounds([0, 0, event.width, event.height]);
        this.update();
    },
    onWindowUpdate : jls.lang.Class.emptyFunction,
    getWindowStyle : function() {
        return jls.win32.Window.WS_OVERLAPPEDWINDOW;
    },
    getTitle : function() {
        if (this._window != null) {
            this._title = this._window.getText();
        }
        return this._title;
    },
    setTitle : function(value) {
        if (this._window != null) {
            this._window.setText(value);
        }
        this._title = value;
        return this;
    }
});

Object.extend(jls.win32.Frame,
{
    classname : 'JLSFrameClass'
});

jls.win32.Window.registerClass(jls.win32.Frame.classname);

