jls.loader.provide('jls.win32.ImageElement');

jls.loader.require('jls.win32.WindowElement');
jls.loader.require('jls.win32.DeviceContext');
jls.loader.require('jls.io.File');
jls.loader.require('jls.io.FileChannel');
jls.loader.require('jls.util.Image');

jls.win32.ImageElement = jls.lang.Class.create(jls.win32.WindowElement,
{
    initialize : function($super, parameters, parent) {
        this._dc = null;
        this._image = null;
        this._width = null; //'100%';
        this._height = null; //'100%';
        $super(parameters, parent);
        this.observe('unload', this.onUnload.bind(this));
        // TODO Fix this workaround, we miss creation messages
        this.onWindowMessage(jls.win32.Window.WM_PAINT);
    },
    onUnload : function() {
        if (this._dc != null) {
            this._dc.release();
        }
    },
    onCreate : function() {
        this._window = new jls.win32.Window(jls.win32.ImageElement.classname, undefined, this.getWindowStyle(),
                this.getX(), this.getY(), this.getW(), this.getH(),
                this.getParentWindow(true), this.getWindowId(true), this.getWindowExStyle());
        this._dc = new jls.win32.DeviceContext(this._window);
    },
    onWindowMessage: function($super, message, wParam, lParam) {
    	//jls.logger.warn('onWindowMessage(' + jls.win32.Window.getMessageName(message) + ', ' + wParam + ', ' + lParam + ')');
    	$super(message, wParam, lParam);
        switch(message) {
        case jls.win32.Window.WM_PAINT:
            if ((this._dc != null) && (this._image != null)) {
            	if ((this.getStyle().getPropertyValue('width') != null) && (this.getStyle().getPropertyValue('height') != null)) {
                    this._dc.stretchDIBits(this._image, this.getStyle().getPropertyValue('width'), this.getStyle().getPropertyValue('height'));
            	} else {
                    this._dc.setDIBits(this._image, 0, 0);
            	}
            }
            this._window.validate(); // validates the whole client area 
            return false; // do not use default message handler
        }
    },
    getWidth : function() {
        return this._width;
    },
    setWidth : function(width) {
        this._width = width;
    },
    getHeight : function() {
        return this._height;
    },
    setHeight : function(height) {
        this._height = height;
        // TODO Update
    },
    getImage : function() {
        return this._image;
    },
    _updateSize : function() {
        if (this._image == null) {
            // default
            this.getStyle().setProperty('width', 32);
            this.getStyle().setProperty('height', 32);
            return;
        }
        var width = null;
        var height = null;
        if (this._width != null) {
            width = jls.win32.ImageElement.computeSize(this._width, this._image.getWidth());
        }
        if (this._height != null) {
            height = jls.win32.ImageElement.computeSize(this._height, this._image.getHeight());
        }
        if ((width == null) && (height == null)) {
            width = this._image.getWidth();
            height = this._image.getHeight();
        } else if (width == null) {
            width = Math.round(this._image.getWidth() * height / this._image.getHeight());
        } else if (height == null) {
            height = Math.round(this._image.getHeight() * width / this._image.getWidth());
        }
        this.getStyle().setProperty('width', width);
        this.getStyle().setProperty('height', height);
        this.getParent().update(); // if size changed
        // TODO Fix this workaround
        this.onWindowMessage(jls.win32.Window.WM_PAINT);
        //jls.logger.warn('ImageElement._updateSize() => ' + width + 'x' + height + ' (' + this._width.toString() + 'x' + this._height + ')');
    },
    setImage : function(name) {
        var f = new jls.io.File(name);
        if (! f.exists()) {
            this._updateSize();
            return this;
        }
        //jls.logger.warn('ImageElement: loading "' + name + '"...');
        var fc = new jls.io.FileChannel(f);
        var img = null;
        if (name.endsWith('.bmp')) {
            img = jls.util.Image.readBMP(fc);
        } else if (name.endsWith('.jpg')) {
            img = jls.util.Image.readJPEG(fc, jls.util.Image.COLOR_SPACE_BGR);
        }
        fc.close();
        this._image = img;
        this._updateSize();
        return this;
    }
});

Object.extend(jls.win32.ImageElement,
{
    classname : 'JLSImageClass',
    computeSize : function(value, size) {
        if (value == null) {
            return size;
        }
        if (typeof value == 'number') {
            return value;
        }
        if ((typeof value != 'string') || (value.length == 0)) {
            throw new jls.lang.Exception('Illegal type of value "' + (typeof value) + '"');
        }
        value = value.match(/([0-9]+)(.*)/);
        var numberValue = value[1];
        var typeValue = value[2] || 'px';
        switch (typeValue) {
        case 'px':
            return Math.round(numberValue);
        case '%':
            return Math.round(numberValue * size / 100);
        default:
            throw new jls.lang.Exception('Illegal size type "' + typeValue + '"');
        }
    }
});

jls.win32.Window.registerClass(jls.win32.ImageElement.classname);

