jls.loader.provide('jls.win32.Label');

jls.loader.require('jls.win32.WindowElement');
jls.loader.require('jls.win32.Static');

jls.win32.Label = jls.lang.Class.create(jls.win32.WindowElement,
{
    initialize : function($super, parameters, parent) {
        this._text = '';
        $super(parameters, parent);
    },
    onCreate : function() {
        this._window = new jls.win32.Static(this.getText(), this.getWindowStyle(),
                this.getX(), this.getY(), this.getW(), this.getH(),
                this.getParentWindow(true), this.getWindowId(true), this.getWindowExStyle());
    },
    getText : function() {
        if (this._window != null) {
            this._text = this._window.getText();
        }
        return this._text;
    },
    setText : function(value) {
        if (this._window != null) {
            this._window.setText(value);
        }
        this._text = value;
        return this;
    }
});

