jls.loader.provide('jls.win32.Menu');

jls.loader.requireLibrary('jls_win32');

jls.win32.Menu = jls.lang.Class.create(
{
    initialize : function(popup) {
        this._no = new _native.win32.Menu(popup);
    },
    append : function(flags, idNewItem, data) {
    	if (idNewItem instanceof jls.win32.Menu) {
    		idNewItem = idNewItem._no;
    	}
        return this._no.append(flags, idNewItem, data);
    },
    insert : function(position, flags, idNewItem, data) {
    	if (idNewItem instanceof jls.win32.Menu) {
    		idNewItem = idNewItem._no;
    	}
        return this._no.insert(position, flags, idNewItem, data);
    },
    enable : function(id, flags) {
        return this._no.enable(id, flags);
    },
    state : function(id, flags) {
        return this._no.state(id, flags);
    },
    remove : function(position, flags) {
    	flags = flags || jls.win32.Menu.MF_BYPOSITION;
        return this._no.remove(position, flags);
    },
    handle : function() {
        return this._no.handle();
    },
    trackPopup : function(window, x, y) {
    	if (! (window instanceof jls.win32.Window)) {
    		throw new jls.lang.Exception('Invalid window argument');
    	}
        return this._no.trackPopup(window._no, x, y);
    }
});

/*Object.extend(jls.win32.Menu,
{
    _nop : null,
    nop : function() {
    }
});*/

Object.inheritConstants(jls.win32.Menu, _native.win32.Menu);
