jls.loader.provide('jls.win32.MenuItem');

jls.loader.require('jls.gui.Element');
jls.loader.require('jls.win32.WindowElement');
jls.loader.require('jls.win32.Menu');

/*
 * TODO Separate Menu and MenuItem
 */
jls.win32.MenuItem = jls.lang.Class.create(
{
    initialize : function(parameters, parent) {
        parameters = parameters || {};
        this._parent = null;
    	this._label = (('label' in parameters) && (typeof parameters.label == 'string')) ? parameters.label : null;
    	this._event = (('event' in parameters) && (typeof parameters.event == 'string')) ? parameters.event : null;
    	this._menu = null;
    	this._id = 0;
    	this._items = null;
    	this._popup = false;
        this._eventsHandlers = null;
    	this._checked = ('checked' in parameters) && (typeof parameters.checked == 'boolean') && parameters.checked;
    	if (('popup' in parameters) && (typeof parameters.popup == 'boolean')) {
            this._menu = new jls.win32.Menu(parameters.popup);
        	this._items = [];
        	this._popup = parameters.popup;
            this._eventsHandlers = {};
    	}
        if (parent) {
        	parent.addMenuItem(this);
        }
    },
    onStartObserving: jls.lang.Class.emptyFunction,
    onStopObserving: jls.lang.Class.emptyFunction,
    dispatch : jls.gui.Element.prototype.dispatch,
    observe : jls.gui.Element.prototype.observe,
    isMenu : function() {
        return (this._menu != null) && (this._items != null);
    },
    isPopupMenu : function() {
        return this._popup && this.isMenu();
    },
    addMenuItem : function(menu) {
    	if ((! this.isMenu()) || ((! menu.isPopupMenu()) && (menu.isMenu()))) {
    		throw new jls.lang.Exception('Cannot add menu item to this menu');
    	}
    	var flags = 0;
    	var id = 0;
    	var label = menu._label;
        if (label != null) {
        	flags |= jls.win32.Menu.MF_STRING;
        } else {
        	label = '';
        	flags |= jls.win32.Menu.MF_SEPARATOR;
        }
        if (menu._checked) {
        	flags |= jls.win32.Menu.MF_CHECKED;
        }
        if (menu.isPopupMenu()) {
    		flags |= jls.win32.Menu.MF_POPUP;
    		id = menu._menu;
    	} else {
    		id = menu._id = jls.win32.MenuItem._nextUid();
    	}
    	menu._parent = this;
    	this._items.push(menu);
    	this._menu.append(flags, id, label);
    },
    getId : function() {
        return this._id;
    },
    getLabel : function() {
        return this._label;
    },
    getItemCount : function(index) {
        return this._items.length;
    },
    getItem : function(index) {
        return this._items[index];
    },
    getItemById : function(id) {
    	if (! this.isMenu()) {
    		throw new jls.lang.Exception('Cannot get menu item from this menu');
    	}
    	for (var i = 0; i < this._items.length; i++) {
    		var item = this._items[i];
    		if (item.getId() == id) {
    			return item;
    		}
    		if (item.isMenu()) {
    			item = item.getItemById(id);
        		if (item != null) {
        			return item;
        		}
    		}
    	}
        return null;
    },
    removeMenuItem : function(item) {
        var index = 0;
        if (typeof item == 'number') {
            index = item;
            if ((index < 0) || (index >= this._items.length)) {
                throw new jls.lang.Exception('Index out of bound');
            }
        } else {
            for (index = this._items.length - 1; (index >= 0) && (this._items[index] !== item); index--);
            if (index < 0) {
                throw new jls.lang.Exception('Menu Item not found');
            }
        }
        var removed = this._items[index];
        this._items.splice(index, 1);
        this._menu.remove(index, jls.win32.Menu.MF_BYPOSITION);
        return removed;
    },
    getRootMenu : function() {
    	var root = this;
    	while (root._parent != null) {
    		root = root._parent;
    	}
        return root;
    }/*,
    trackPopup : function(element, x, y) {
    	if (! (element instanceof jls.win32.WindowElement)) {
    		throw new jls.lang.Exception('Invalid element argument');
    	}
        return this._menu.trackPopup(element._window, x, y);
    }*/
});

Object.extend(jls.win32.MenuItem,
{
	_uid : 1,
    _nextUid : function() {
    	return jls.win32.MenuItem._uid++;
    },
    createMenu : function() {
    	return new jls.win32.MenuItem({popup: false});
    },
    createPopupMenu : function() {
    	return new jls.win32.MenuItem({popup: true});
    },
    createMenuSeparator : function(menu) {
    	return new jls.win32.MenuItem({}, menu);
    }
});
