jls.loader.provide('jls.win32.ShellNotifyIcon');

jls.loader.requireLibrary('jls_win32');

/*jls.win32.ShellNotifyIcon = jls.lang.Class.create(
{
    initialize : function(window, id, flags, cbMsg) {
        if (! (window instanceof jls.win32.Window)) {
            throw new jls.lang.Exception('Invalid window argument type (' + (typeof window) + ')');
        }
        this._item = new jls.lang.Struct([
                                          {name: 'cbSize', type: 'UnsignedInt'},
                                          {name: 'hWnd', type: 'Pointer'},
                                          {name: 'uID', type: 'UnsignedInt'},
                                          {name: 'uFlags', type: 'UnsignedInt'},
                                          {name: 'uCallbackMessage', type: 'UnsignedInt'},
                                          {name: 'hIcon', type: 'Pointer'},
                                          {name: 'szTip', type: 'UnsignedShort', size: 64},
                                          {name: 'dwState', type: 'UnsignedInt'},
                                          {name: 'dwStateMask', type: 'UnsignedInt'},
                                          {name: 'szInfo', type: 'UnsignedShort', size: 64},
                                          {name: 'uTimeout', type: 'UnsignedInt'},
                                          {name: 'szInfoTitle', type: 'UnsignedShort', size: 64},
                                          {name: 'dwInfoFlags', type: 'UnsignedInt'},
                                          {name: 'guidItem', type: 'UnsignedInt'},
                                          {name: 'hBalloonIcon', type: 'Pointer'}
                                      ]);
    	this._item.put('cbSize', this._item.size());
    	this._item.put('hWnd', window._no.handle());
    	this._item.put('uID', id);
    	this._item.put('uFlags', flags);
    	this._item.put('uCallbackMessage', cbMsg);
    },
    notify : function(message) {
        return _native.win32.shellNotifyIcon(message, this._item.buffer().byteArray());
    },
    setTip : function(text) {
        //this._no.setTip(text);
        return this;
    },
    setIcon : function(icon) {
        if (! (icon instanceof jls.win32.Image)) {
            throw new jls.lang.Exception('Invalid icon argument type (' + (typeof window) + ')');
        }
    	this._item.put('hIcon', icon._no.handle());
        return this;
    }
});*/

jls.win32.ShellNotifyIcon = jls.lang.Class.create(
{
    initialize : function(window, id, flags, cbMsg) {
        if (! (window instanceof jls.win32.Window)) {
            throw new jls.lang.Exception('Invalid window argument type (' + (typeof window) + ')');
        }
        this._no = new _native.win32.ShellNotifyIcon(window._no, id, flags, cbMsg);
    },
    notify : function(message) {
        this._no.notify(message);
        return this;
    },
    setTip : function(text) {
        this._no.setTip(text);
        return this;
    },
    setIcon : function(icon) {
        if (! (icon instanceof jls.win32.Image)) {
            throw new jls.lang.Exception('Invalid icon argument type (' + (typeof window) + ')');
        }
        this._no.setIcon(icon._no);
        return this;
    }
});

Object.extend(jls.win32.ShellNotifyIcon,
{
	NIM_ADD :      0x00000000,
	NIM_MODIFY :   0x00000001,
	NIM_DELETE :   0x00000002,
	NIF_MESSAGE :  0x00000001,
	NIF_ICON :     0x00000002,
	NIF_TIP :      0x00000004,
	NIF_STATE :    0x00000008,
	NIF_INFO :     0x00000010,
	NIF_REALTIME : 0x00000040,
	NIF_SHOWTIP :  0x00000080
});

