jls.loader.provide('jls.win32.ShellNotifyIconElement');

jls.loader.require('jls.win32.WindowElement');
jls.loader.require('jls.win32.ShellNotifyIcon');

jls.win32.ShellNotifyIconElement = jls.lang.Class.create(jls.win32.WindowElement,
{
    initialize : function($super, parameters, parent) {
        this._notifIcon = null;
        this._tip = null;
        if (typeof parent != 'undefined') {
            throw new jls.lang.Exception('ShellNotifyIconElement takes no parent');
        }
        $super(parameters, parent);
    },
    onCreate : function() {
        this._window = new jls.win32.Window(jls.win32.ShellNotifyIconElement.CLASSNAME, undefined, 0);
        this._notifIcon = new jls.win32.ShellNotifyIcon(this._window, 1 /* id */,
            jls.win32.ShellNotifyIcon.NIF_ICON | jls.win32.ShellNotifyIcon.NIF_MESSAGE | jls.win32.ShellNotifyIcon.NIF_TIP,
            jls.win32.Window.WM_USER);
        this._notifIcon.notify(jls.win32.ShellNotifyIcon.NIM_ADD);
        jls.logger.trace('Add icon');
        if (this._tip) {
            this.setTip(this._tip);
        }
    },
    onWindowMessage: function($super, message, wParam, lParam) {
    	$super(message, wParam, lParam);
        switch(message) {
        case jls.win32.Window.WM_USER:
            switch(lParam) {
            case jls.win32.Window.WM_LBUTTONDOWN:
                // TODO Use jls.win32.WindowElement.createMouseEvent
                this.dispatch(jls.gui.Event.createMouseEvent('mousedown', this, jls.gui.Event.MOUSE_BUTTON_LEFT, 0, 0, 0, 0));
                break;
            case jls.win32.Window.WM_LBUTTONUP:
                this.dispatch(jls.gui.Event.createMouseEvent('mouseup', this, jls.gui.Event.MOUSE_BUTTON_LEFT, 0, 0, 0, 0));
                this.dispatch(jls.gui.Event.createMouseEvent('click', this, jls.gui.Event.MOUSE_BUTTON_LEFT, 0, 0, 0, 0));
                break;
            case jls.win32.Window.WM_LBUTTONDBLCLK:
                this.dispatch(jls.gui.Event.createMouseEvent('dblclick', this, jls.gui.Event.MOUSE_BUTTON_LEFT, 0, 0, 0, 0));
                break;
            case jls.win32.Window.WM_MBUTTONDOWN:
                this.dispatch(jls.gui.Event.createMouseEvent('mousedown', this, jls.gui.Event.MOUSE_BUTTON_MIDDLE, 0, 0, 0, 0));
                break;
            case jls.win32.Window.WM_MBUTTONUP:
                this.dispatch(jls.gui.Event.createMouseEvent('mouseup', this, jls.gui.Event.MOUSE_BUTTON_MIDDLE, 0, 0, 0, 0));
                this.dispatch(jls.gui.Event.createMouseEvent('click', this, jls.gui.Event.MOUSE_BUTTON_MIDDLE, 0, 0, 0, 0));
                break;
            case jls.win32.Window.WM_MBUTTONDBLCLK:
                this.dispatch(jls.gui.Event.createMouseEvent('dblclick', this, jls.gui.Event.MOUSE_BUTTON_MIDDLE, 0, 0, 0, 0));
                break;
            case jls.win32.Window.WM_RBUTTONDOWN:
                this.dispatch(jls.gui.Event.createMouseEvent('mousedown', this, jls.gui.Event.MOUSE_BUTTON_RIGHT, 0, 0, 0, 0));
                break;
            case jls.win32.Window.WM_RBUTTONUP:
                this.dispatch(jls.gui.Event.createMouseEvent('mouseup', this, jls.gui.Event.MOUSE_BUTTON_RIGHT, 0, 0, 0, 0));
                this.dispatch(jls.gui.Event.createMouseEvent('click', this, jls.gui.Event.MOUSE_BUTTON_RIGHT, 0, 0, 0, 0));
                break;
            case jls.win32.Window.WM_RBUTTONDBLCLK:
                this.dispatch(jls.gui.Event.createMouseEvent('dblclick', this, jls.gui.Event.MOUSE_BUTTON_RIGHT, 0, 0, 0, 0));
                break;
            case jls.win32.Window.WM_MOUSEMOVE:
                this.dispatch(jls.gui.Event.createMouseEvent('mousemove', this, -1, 0, 0, 0, 0));
                break;
            }
            break;
        }
    },
    onDestroy : function($super) {
        $super();
        this._notifIcon.notify(jls.win32.ShellNotifyIcon.NIM_DELETE);
        return this;
    },
    /*setIcon : function(icon) {
        this._notifIcon.setIcon(icon);
        return this;
    },*/
    setIcon : function(name) {
        var icon = jls.win32.WindowElement.getIcon(name);
        if (icon) {
            this._icon = name;
            if (this._notifIcon) {
                jls.logger.trace('Set icon: "' + name + '"');
                this._notifIcon.setIcon(icon);
                this.update();
            }
        }
        return this;
    },
    setTip : function(tip) {
        this._tip = tip;
        if (this._notifIcon) {
            this._notifIcon.setTip(tip);
            this.update();
        }
        return this;
    },
    update : function() {
        this._notifIcon.notify(jls.win32.ShellNotifyIcon.NIM_MODIFY);
        return this;
    }
});

Object.extend(jls.win32.ShellNotifyIconElement,
{
    CLASSNAME : 'ShellNotifyIconClass'
});

jls.win32.Window.registerClass(jls.win32.ShellNotifyIconElement.CLASSNAME);
