jls.loader.provide('jls.win32.TabControl');

jls.loader.require('jls.win32.Window');
jls.loader.require('jls.lang.Struct');
jls.loader.require('jls.lang.ByteBuffer');
jls.loader.require('jls.lang.CharBuffer');

jls.win32.TabControl = jls.lang.Class.create(jls.win32.Window,
{
    initialize : function($super, title, style, x, y, w, h, parent, id, exStyle, param) {
        $super(jls.win32.TabControl.CLASSNAME, title, style, x, y, w, h, parent, id, exStyle, param);
        this._item = new jls.lang.Struct([
            {name: 'mask', type: 'UnsignedInt'},
            {name: 'dwState', type: 'SignedInt'},
            {name: 'dwStateMask', type: 'SignedInt'},
            {name: 'pszText', type: 'Pointer'},
            {name: 'cchTextMax', type: 'SignedInt'},
            {name: 'iImage', type: 'SignedInt'},
            {name: 'lParam', type: 'SignedInt'}
        ]);
        //this._textBuffer = jls.lang.ByteBuffer.allocate(256);
        this._textBuffer = jls.lang.CharBuffer.allocate(256);
    },
    getSelectedIndex : function() {
        return this.sendMessage(jls.win32.TabControl.TCM_GETCURSEL, 0, 0);
    },
    setSelectedIndex : function(index) {
        this.sendMessage(jls.win32.TabControl.TCM_SETCURSEL, index, 0);
    },
    insertItem : function(label, index) {
        //jls.logger.warn('TabControl.insertItem("' + label + '")');
        this._textBuffer.clear();
        this._textBuffer.putString(label || '');
        //this._textBuffer.putByte(0);
        this._textBuffer.putChar(0);
        //this._item.put('mask', jls.win32.TabControl.TCIF_TEXT | jls.win32.TabControl.TCIF_IMAGE);
    	this._item.put('mask', jls.win32.TabControl.TCIF_TEXT);
        //this._item.put('dwState', 0);
        //this._item.put('dwStateMask', 0);
    	//jls.logger.warn('TabControl.insertItem() item: 0x' + this._item.buffer().byteArray().pointer().toString(16) + ', label: 0x' + this._textBuffer.byteArray().pointer().toString(16));
        this._item.put('pszText', this._textBuffer.byteArray().pointer());
        //this._item.put('cchTextMax', 0);
        this._item.put('iImage', -1);
        this._item.put('lParam', 0);
        //return this.sendMessage(jls.win32.TabControl.TCM_INSERTITEMA, index || 0, this._item.buffer().byteArray());
        return this.sendMessage(jls.win32.TabControl.TCM_INSERTITEMW, index || 0, this._item.buffer().byteArray());
    }
});
/*
typedef struct {
  UINT   mask;
#if (_WIN32_IE >= 0x0300)
  DWORD  dwState;
  DWORD  dwStateMask;
#else 
  UINT   lpReserved1;
  UINT   lpReserved2;
#endif 
  LPTSTR pszText;
  int    cchTextMax;
  int    iImage;
  LPARAM lParam;
} TCITEM, *LPTCITEM;
*/
Object.extend(jls.win32.TabControl,
{
    TCS_FORCEICONLEFT        : 0x00000010,
    TCS_FORCELABELLEFT       : 0x00000020,
    TCS_TABS                 : 0x00000000,
    TCS_BUTTONS              : 0x00000100,
    TCS_SINGLELINE           : 0x00000000,
    TCS_MULTILINE            : 0x00000200,
    TCS_RIGHTJUSTIFY         : 0x00000000,
    TCS_FIXEDWIDTH           : 0x00000400,
    TCS_RAGGEDRIGHT          : 0x00000800,
    TCS_FOCUSONBUTTONDOWN    : 0x00001000,
    TCS_OWNERDRAWFIXED       : 0x00002000,
    TCS_TOOLTIPS             : 0x00004000,
    TCS_FOCUSNEVER           : 0x00008000,
    
    TCIF_TEXT                : 0x00000001,
    TCIF_IMAGE               : 0x00000002,
    TCIF_RTLREADING          : 0x00000004,
    TCIF_PARAM               : 0x00000008,
    TCIS_BUTTONPRESSED       : 0x00000001,
    
    TCM_FIRST                : 0x00001300,
    TCM_GETIMAGELIST         : 0x00001302,
    TCM_SETIMAGELIST         : 0x00001303,
    TCM_GETITEMCOUNT         : 0x00001304,
    TCM_GETITEMA             : 0x00001305,
    TCM_GETITEMW             : 0x0000133c,
    TCM_SETITEMA             : 0x00001306,
    TCM_SETITEMW             : 0x0000133d,
    TCM_INSERTITEMA          : 0x00001307,
    TCM_INSERTITEMW          : 0x0000133e,
    TCM_DELETEITEM           : 0x00001308,
    TCM_DELETEALLITEMS       : 0x00001309,
    TCM_GETITEMRECT          : 0x0000130a,
    TCM_GETCURSEL            : 0x0000130b,
    TCM_SETCURSEL            : 0x0000130c,
    TCM_HITTEST              : 0x0000130d,
    TCM_SETITEMEXTRA         : 0x0000130e,
    TCM_ADJUSTRECT           : 0x00001328,
    TCM_SETITEMSIZE          : 0x00001329,
    TCM_REMOVEIMAGE          : 0x0000132a,
    TCM_SETPADDING           : 0x0000132b,
    TCM_GETROWCOUNT          : 0x0000132c,
    TCM_GETTOOLTIPS          : 0x0000132d,
    TCM_SETTOOLTIPS          : 0x0000132e,
    TCM_GETCURFOCUS          : 0x0000132f,
    TCM_SETCURFOCUS          : 0x00001330,
    TCM_SETMINTABWIDTH       : 0x00001331,
    TCM_DESELECTALL          : 0x00001332,
    TCN_KEYDOWN              : 0xfffffdda,
    TCN_SELCHANGE            : 0xfffffdd9,
    TCN_SELCHANGING          : 0xfffffdd8,

    CLASSNAME: 'SysTabControl32'
});
