jls.loader.provide('jls.win32.TabElement');

jls.loader.require('jls.win32.WindowElement');
jls.loader.require('jls.win32.TabControl');
jls.loader.require('jls.gui.CardLayout');

jls.win32.TabElement = jls.lang.Class.create(jls.win32.WindowElement,
{
    initialize : function($super, parameters, parent) {
    	this._selectOnAdd = false;
        $super(parameters, parent);
        this.observe('change', this.onChange.bind(this));
    },
    onCreate : function() {
        this._window = new jls.win32.TabControl('', this.getWindowStyle(),
                this.getX(), this.getY(), this.getW(), this.getH(),
                this.getParentWindow(true), this.getWindowId(true), this.getWindowExStyle());
    },
    createDefaultLayout : function() {
        return new jls.gui.CardLayout(this);
    },
    /*getWindowStyle : function($super) {
    return jls.win32.Window.WS_CHILD | jls.win32.Window.WS_VISIBLE;// | jls.win32.Button.BS_BITMAP | jls.win32.Button.BS_ICON;
	},*/
    getClientSize : function() {
        // TODO Fix this
        return [this.getW() - 6, this.getH() - 31];
    },
    getClientOffset : function() {
        // TODO Fix this
        return [3, 28];
    },
    onChange : function(event) {
    	//jls.logger.warn('onChange(' + event.index + ')');
        this._layout.show(event.index);
    },
    onWindowMessage: function($super, message, wParam, lParam) {
    	//jls.logger.warn('onWindowMessage(' + jls.win32.Window.getMessageName(message) + ', ' + wParam + ', ' + lParam + ')');
        switch(message) {
        case jls.win32.Window.WM_CTLNOTIFY:
        	//jls.logger.warn('onCtlNotify(' + jls.win32.Window.getMessageName(lParam, jls.win32.TabControl, 'TCN_') + ')');
        	if (wParam != this._windowId) {
        		break;
        	}
            switch(lParam) {
            case jls.win32.TabControl.TCN_SELCHANGE :
                var event = new jls.gui.Event('change', this);
                var sel = this._window.getSelectedIndex();
            	//jls.logger.warn('sel: ' + sel);
                event.index = sel;
                this.dispatch(event);
            	break;
            }
        	
        	return;
        }
        $super(message, wParam, lParam);
    },
    setSelectOnAdd : function(value) {
    	this._selectOnAdd = value;
    },
    getSelectOnAdd : function() {
    	return this._selectOnAdd;
    },
    addChild : function($super, child) {
    	var label = child.getAttribute('title');
		var childCount = this.getChildCount()
    	var index = this._window.insertItem(label, childCount);
    	//jls.logger.warn('index: ' + index);
    	child = $super(child);
		if ((childCount > 0) && this._selectOnAdd) {
			this._window.setSelectedIndex(index);
			var event = new jls.gui.Event('change', this);
			event.index = index;
			this.dispatch(event);
		}
		return child;
    }
});

