jls.loader.provide('jls.win32.TreeView');

jls.loader.require('jls.win32.Window');

jls.win32.TreeView = jls.lang.Class.create(jls.win32.Window,
{
    initialize : function($super, title, style, x, y, w, h, parent, id, exStyle, param) {
        $super(jls.win32.TreeView.CLASSNAME, title, style, x, y, w, h, parent, id, exStyle, param);
        this._item = new jls.lang.Struct([
            {name: 'hParent', type: 'Pointer'},
            {name: 'hInsertAfter', type: 'Pointer'},
            {name: 'item.mask', type: 'UnsignedInt'},
            {name: 'item.hItem', type: 'Pointer'},
            {name: 'item.state', type: 'UnsignedInt'},
            {name: 'item.stateMask', type: 'UnsignedInt'},
            {name: 'item.pszText', type: 'Pointer'},
            {name: 'item.cchTextMax', type: 'SignedInt'},
            {name: 'item.iImage', type: 'SignedInt'},
            {name: 'item.iSelectedImage', type: 'SignedInt'},
            {name: 'item.cChildren', type: 'SignedInt'},
            {name: 'item.lParam', type: 'Pointer'}
        ]);
        this._textBuffer = jls.lang.ByteBuffer.allocate(256);
    },
    insertRootItem : function(label) {
        var item = new jls.win32.TreeView.Item(label);
        this.insertItem(item);
        return item;
    },
    insertItem : function(item) {
        this._item.put('hParent', item.isRoot() ? jls.win32.TreeView.TVI_ROOT : item.getParent()._handle);
        this._item.put('hInsertAfter', 0);
        this._item.put('item.mask', jls.win32.TreeView.TVIF_TEXT | jls.win32.TreeView.TVIF_IMAGE);
        this._textBuffer.clear();
        var label = item.getLabel();
        this._textBuffer.putString(label);
        this._textBuffer.putByte(0);
        this._item.put('item.pszText', this._textBuffer.byteArray().pointer());
        this._item.put('item.cchTextMax', label.length + 1);
        this._item.put('item.iImage', -1);
        this._item.put('item.iSelectedImage', -1);
        this._item.put('item.cChildren', 0);
        this._item.put('item.lParam', 0);
        item._handle = this.sendMessage(jls.win32.TreeView.TVM_INSERTITEMA, 0, this._item.buffer().byteArray());
        item._tree = this;
        return item;
    }
});

jls.win32.TreeView.Item = jls.lang.Class.create(
{
    initialize : function(label) {
        this._label = label || '';
        this._parent = null;
    },
    getLabel : function() {
        return this._label;
    },
    getParent : function() {
        return this._parent;
    },
    isRoot : function() {
        return this._parent == null;
    },
    insert : function(item) {
        item._parent = this;
        this._tree.insertItem(item);
        return item;
    }
});

Object.extend(jls.win32.TreeView,
{
    TVS_HASBUTTONS           : 0x00000001,
    TVS_HASLINES             : 0x00000002,
    TVS_LINESATROOT          : 0x00000004,
    TVS_EDITLABELS           : 0x00000008,
    TVS_DISABLEDRAGDROP      : 0x00000010,
    TVS_SHOWSELALWAYS        : 0x00000020,
    TVM_INSERTITEMA          : 0x00001100,
    TVM_INSERTITEMW          : 0x00001132,
    TVM_DELETEITEM           : 0x00001101,
    TVM_EXPAND               : 0x00001102,
    TVM_GETITEMRECT          : 0x00001104,
    TVM_GETCOUNT             : 0x00001105,
    TVM_GETINDENT            : 0x00001106,
    TVM_SETINDENT            : 0x00001107,
    TVM_GETIMAGELIST         : 0x00001108,
    TVM_SETIMAGELIST         : 0x00001109,
    TVM_GETNEXTITEM          : 0x0000110a,
    TVM_SELECTITEM           : 0x0000110b,
    TVM_GETITEMA             : 0x0000110c,
    TVM_GETITEMW             : 0x0000113e,
    TVM_SETITEMA             : 0x0000110d,
    TVM_SETITEMW             : 0x0000113f,
    TVM_EDITLABELA           : 0x0000110e,
    TVM_EDITLABELW           : 0x00001141,
    TVM_GETEDITCONTROL       : 0x0000110f,
    TVM_GETVISIBLECOUNT      : 0x00001110,
    TVM_HITTEST              : 0x00001111,
    TVM_CREATEDRAGIMAGE      : 0x00001112,
    TVM_SORTCHILDREN         : 0x00001113,
    TVM_ENSUREVISIBLE        : 0x00001114,
    TVM_SORTCHILDRENCB       : 0x00001115,
    TVM_ENDEDITLABELNOW      : 0x00001116,
    TVM_GETISEARCHSTRINGA    : 0x00001117,
    TVM_GETISEARCHSTRINGW    : 0x00001140,
    TVI_ROOT                 : 0xffff0000,
    TVI_FIRST                : 0xffff0001,
    TVI_LAST                 : 0xffff0002,
    TVI_SORT                 : 0xffff0003,
    TVIF_TEXT                : 0x00000001,
    TVIF_IMAGE               : 0x00000002,
    TVIF_PARAM               : 0x00000004,
    TVIF_STATE               : 0x00000008,
    TVIF_HANDLE              : 0x00000010,
    TVIF_SELECTEDIMAGE       : 0x00000020,
    TVIF_CHILDREN            : 0x00000040,
    TVIS_FOCUSED             : 0x00000001,
    TVIS_SELECTED            : 0x00000002,
    TVIS_CUT                 : 0x00000004,
    TVIS_DROPHILITED         : 0x00000008,
    TVIS_BOLD                : 0x00000010,
    TVIS_EXPANDED            : 0x00000020,
    TVIS_EXPANDEDONCE        : 0x00000040,
    TVIS_OVERLAYMASK         : 0x00000f00,
    TVIS_STATEIMAGEMASK      : 0x0000f000,
    TVIS_USERMASK            : 0x0000f000,

    CLASSNAME: 'SysTreeView32'
});
