jls.loader.provide('jls.win32.Window');

jls.loader.requireLibrary('jls_win32');

jls.loader.require('jls.gui.Event');
jls.loader.require('jls.win32.Font');
jls.loader.require('jls.win32.Pen');
jls.loader.require('jls.win32.Brush');
jls.loader.require('jls.win32.Image');

jls.win32.Window = jls.lang.Class.create(
{
    /*
     * If the window has the WS_CAPTION style of dwStyle set, the specified name (if non-empty) appears in the window's title bar.
     * If the window being created is a control (such as button, static control or edit control), lpszWindowName is used to specify the text of the control.
     */
    // TODO Make arguments as a parameter object, keep classname?
    initialize : function(classname, name, style, x, y, w, h, parent, menuOrId, exStyle, param) {
        jls.win32.Window.initializeThreadWindow();
        // TODO Keep top level windows and destroy thread window when there is no more top level window
        // TODO Add children to parent to avoid garbage collection
        if (typeof style == 'undefined') {
            style = parent ? jls.win32.Window.WS_CHILD | jls.win32.Window.WS_VISIBLE : jls.win32.Window.WS_OVERLAPPEDWINDOW;
        }
        this._no = jls.win32.Window._createWindow(classname, name, style, x, y, w, h, (parent ? parent._no : undefined), menuOrId, exStyle, param);
        if (this._no == null) {
            throw new jls.lang.Exception('Fail to create window');
        }
        this._dc = null;
        this._eventsHandlers = {};
    },
    isWindowVisible : function() {
        return this._no.isWindowVisible();
    },
    show : function(mode) {
        return this._no.show(mode);
    },
    update : function() {
        this._no.update();
        return this;
    },
    validate : function() {
        this._no.validateRect();
        return this;
    },
    close : function(mode) {
        this.sendMessage(jls.win32.Window.WM_CLOSE, 0, 0);
    },
    handle : function() {
        return this._no.handle();
    },
    getTextLength : function() {
    	return this._no.sendMessage(jls.win32.Window.WM_GETTEXTLENGTH, 0, 0);
    },
    getText : function() {
        return this._no.getText();
    },
    setText : function(text) {
        return this._no.setText(text);
    },
    setIcon : function(icon, size) {
    	if (! ((icon instanceof jls.win32.Image) && (icon.getType() == jls.win32.Image.IMAGE_ICON))) {
    		throw new jls.lang.Exception();
    	}
        return this.sendMessage(jls.win32.Window.WM_SETICON, size || jls.win32.Window.ICON_SMALL, icon);
    },
    setPosition : function(x, y, w, h, uiFlags, insertAfter) {
        return this._no.setPosition(x, y, w, h, uiFlags, insertAfter);
    },
    rect : function(client) {
        return this._no.rect(client);
    },
    setMenu : function(menu) {
    	if (! (menu instanceof jls.win32.Menu)) {
    		throw new jls.lang.Exception('Invalid menu argument');
    	}
        return this._no.setMenu(menu._no);
    },
    /*
     * TODO Add capture
     * HWND WINAPI SetCapture(HWND hWnd);
     * BOOL WINAPI ReleaseCapture(void);
     * BOOL WINAPI TrackMouseEvent(LPTRACKMOUSEEVENT lpEventTrack);
     * WM_CAPTURECHANGED
     */
    setCapture : function() {
    	this._no.setCapture();
    },
    trackMouseEvent : function(flags, hoverTime) {
    	flags = flags || jls.win32.Window.TME_LEAVE;
        return this._no.trackMouseEvent(flags, hoverTime);
    },
    getDeviceContext : function() {
        if (this._dc == null) {
            this._dc = new jls.win32.DeviceContext(this);
        }
        return this._dc;
    },
    postMessage : function(uMsg, wParam, lParam, unicode, sct) {
        if (jls.win32.Window._hasWin32NativeObject(wParam)) {
            wParam = wParam._no;
        }
        if (jls.win32.Window._hasWin32NativeObject(lParam)) {
            lParam = lParam._no;
        }
        return this._no.postMessage(uMsg, wParam, lParam, unicode, sct);
    },
    sendMessage : function(uMsg, wParam, lParam, unicode, sct) {
        if (jls.win32.Window._hasWin32NativeObject(wParam)) {
            wParam = wParam._no;
        }
        if (jls.win32.Window._hasWin32NativeObject(lParam)) {
            lParam = lParam._no;
        }
        return this._no.sendMessage(uMsg, wParam, lParam, unicode, sct);
    },
    setWindowFunction : function(fn) {
        this._no.setWindowFunction(fn || null);
        return this;
    }
});

Object.extend(jls.win32.Window,
{
    _threadWindow : null,
    _thread : null,
    _createWindow : function(classname, name, style, x, y, w, h, parent, menu, exStyle, param) {
        return jls.win32.Window._threadWindow.sendMessage(jls.win32.Window.WM_CREATE_WINDOW, null, {
            classname: classname,
            name: name,
            style: style,
            x: x,
            y: y,
            w: w,
            h: h,
            parent: parent,
            menu: menu,
            exStyle: exStyle,
            param: param
        });
    },
    _hasWin32NativeObject : function(obj) {
        return (obj instanceof jls.win32.Font) || (obj instanceof jls.win32.Brush) || (obj instanceof jls.win32.Pen) || (obj instanceof jls.win32.Image);
    },
    invokeAndWait : function(fn) {
        jls.win32.Window.initializeThreadWindow();
        return jls.win32.Window._threadWindow.sendMessage(jls.win32.Window.WM_INVOKE, null, {
            fn: fn
        });
    },
    invokeLater : function(fn) {
        jls.win32.Window.initializeThreadWindow();
        jls.win32.Window._threadWindow.postMessage(jls.win32.Window.WM_INVOKE, null, {
            fn: fn
        });
    },
    releaseCapture : function() {
    	_native.win32.Window.releaseCapture();
    },
    // TODO Move this function elsewhere
    shellExecute : function(file, showCmd, directory, operation, parameters) {
    	_native.win32.shellExecute(file/*, showCmd, directory, operation, parameters*/);
    },
    splitWord : function(value) {
    	return [(value >> 16) & 65535, value & 65535];
    },
    hiWord : function(value) {
    	return (value >> 16) & 65535;
    },
    loWord : function(value) {
    	return value & 65535;
    },
    makeWord : function(hi, lo) {
    	return ((hi & 65535) << 16) + (lo & 65535);
    },
    getMessageName : function(message, from, prefix) {
    	from = from || jls.win32.Window;
    	prefix = prefix || 'WM_';
        for (var key in from) {
            if (key.startsWith(prefix) && (from[key] == message)) {
                return key;
            }
        }
    	return '0x' + message.toString(16);
    },
    initializeThreadWindow : function() {
        if (jls.win32.Window._threadWindow != null) {
            return;
        }
        _native.win32.registerClass('JLSThreadWindowsClass');
        jls.win32.Window.WM_CREATE_WINDOW = jls.win32.Window.WM_JS_OBJECT;
        jls.win32.Window.WM_INVOKE = jls.win32.Window.WM_JS_OBJECT + 1;
        var mon = new jls.lang.Monitor();
        jls.win32.Window._thread = new jls.lang.Thread();
        jls.win32.Window._thread.run = function() {
            jls.logger.trace('Create window thread');
            jls.win32.Window._threadWindow = new _native.win32.Window('JLSThreadWindowsClass', '');
        
            jls.win32.Window._threadWindow.setWindowFunction(function(iMsg, wParam, lParam) {
                if (iMsg == jls.win32.Window.WM_DESTROY) {
                    jls.logger.debug('Destroying window');
                    _native.win32.postQuitMessage();
                    jls.logger.debug('...destroyed');
                    return false;
                }
                if (iMsg == jls.win32.Window.WM_CREATE_WINDOW) {
                    if (typeof lParam == 'object') {
                        jls.logger.debug('create window...');
                        var w = new _native.win32.Window(lParam.classname, lParam.name, lParam.style,
                            lParam.x, lParam.y, lParam.w, lParam.h, lParam.parent, lParam.menu, lParam.exStyle, lParam.param);
                        jls.logger.debug('...created');
                        return w;
                    } else {
                        jls.logger.debug('invalid lParam type ' + (typeof lParam));
                    }
                }
                if (iMsg == jls.win32.Window.WM_INVOKE) {
                    if ((typeof lParam == 'object') && ('fn' in lParam)) {
                        jls.logger.debug('Invoke');
                        return lParam.fn();
                    } else {
                        jls.logger.debug('invalid lParam type ' + (typeof lParam));
                    }
                }
            });
            mon.notify();
            
            jls.logger.debug('Start polling win32 messages');
            _native.win32.pollMessage();
            jls.logger.debug('End polling win32 messages');
        }
        jls.logger.debug('Start win32 messages polling thread');
        jls.win32.Window._thread.start();
        jls.logger.trace('Wait for polling to start...');
        mon.wait();
        jls.logger.debug('Window initialized');
    },
    destroyThreadWindow : function() {
        if (jls.win32.Window._threadWindow == null) {
            return;
        }
        jls.win32.Window._threadWindow.sendMessage(jls.win32.Window.WM_DESTROY);
        jls.win32.Window._threadWindow = null;
    },
    loadLibrary : function(name) {
        return _native.win32.loadLibrary(name);
    },
    registerClass : function(name, style, syscolor, icon) {
        _native.win32.registerClass(
        		name, false,
        		style ? style : jls.win32.Window.CS_HREDRAW | jls.win32.Window.CS_VREDRAW,
        		syscolor ? syscolor : jls.win32.Window.COLOR_BTNFACE,
        		icon ? icon._no : undefined);
    },

    CS_BYTEALIGNCLIENT: 0x1000,
    CS_BYTEALIGNWINDOW: 0x2000,
    CS_CLASSDC: 0x0040,
    CS_DBLCLKS: 0x0008,
    CS_DROPSHADOW: 0x00020000,
    CS_GLOBALCLASS: 0x4000,
    CS_HREDRAW: 0x0002,
    CS_NOCLOSE: 0x0200,
    CS_OWNDC: 0x0020,
    CS_PARENTDC: 0x0080,
    CS_SAVEBITS: 0x0800,
    CS_VREDRAW: 0x0001,

    /*COLOR_3DDKSHADOW: 21,
    COLOR_3DFACE: 15,
    COLOR_3DHIGHLIGHT: 20,
    COLOR_3DHILIGHT: 20,
    COLOR_3DLIGHT: 22,
    COLOR_3DSHADOW: 16,
    COLOR_ACTIVEBORDER: 10,
    COLOR_ACTIVECAPTION: 2,
    COLOR_APPWORKSPACE: 12,
    COLOR_BACKGROUND: 1,*/
    COLOR_BTNFACE: 15,
    /*COLOR_BTNHIGHLIGHT: 20,
    COLOR_BTNHILIGHT: 20,
    COLOR_BTNSHADOW: 16,
    COLOR_BTNTEXT: 18,
    COLOR_CAPTIONTEXT: 9,
    COLOR_DESKTOP: 1,
    COLOR_GRADIENTACTIVECAPTION: 27,
    COLOR_GRADIENTINACTIVECAPTION: 28,
    COLOR_GRAYTEXT: 17,
    COLOR_HIGHLIGHT: 13,
    COLOR_HIGHLIGHTTEXT: 14,
    COLOR_HOTLIGHT: 26,
    COLOR_INACTIVEBORDER: 11,
    COLOR_INACTIVECAPTION: 3,
    COLOR_INACTIVECAPTIONTEXT: 19,
    COLOR_INFOBK: 24,
    COLOR_INFOTEXT: 23,
    COLOR_MENU: 4,
    COLOR_MENUHILIGHT: 29,
    COLOR_MENUBAR: 30,
    COLOR_MENUTEXT: 7,
    COLOR_SCROLLBAR: 0,
    COLOR_WINDOW: 5,
    COLOR_WINDOWFRAME: 6,
    COLOR_WINDOWTEXT: 8,*/
    
    WS_BORDER                : 0x00800000,
    WS_CAPTION               : 0x00c00000,
    WS_CHILD                 : 0x40000000,
    WS_CHILDWINDOW           : 0x40000000,
    WS_CLIPCHILDREN          : 0x02000000,
    WS_CLIPSIBLINGS          : 0x04000000,
    WS_DISABLED              : 0x08000000,
    WS_DLGFRAME              : 0x00400000,
    WS_GROUP                 : 0x00020000,
    WS_HSCROLL               : 0x00100000,
    WS_MAXIMIZE              : 0x01000000,
    WS_MAXIMIZEBOX           : 0x00010000,
    WS_MINIMIZE              : 0x20000000,
    WS_MINIMIZEBOX           : 0x00020000,
    WS_OVERLAPPEDWINDOW      : 0x00cf0000,
    WS_POPUP                 : 0x80000000,
    WS_POPUPWINDOW           : 0x80880000,
    WS_SYSMENU               : 0x00080000,
    WS_TABSTOP               : 0x00010000,
    WS_THICKFRAME            : 0x00040000,
    WS_VISIBLE               : 0x10000000,
    WS_VSCROLL               : 0x00200000,
    
    WS_EX_ACCEPTFILES        : 0x00000010,
    WS_EX_APPWINDOW          : 0x00040000,
    WS_EX_CLIENTEDGE         : 0x00000200,
    WS_EX_COMPOSITED         : 0x02000000,
    WS_EX_CONTEXTHELP        : 0x00000400,
    WS_EX_CONTROLPARENT      : 0x00010000,
    WS_EX_DLGMODALFRAME      : 0x00000001,
    WS_EX_LAYERED            : 0x00080000,
    WS_EX_LAYOUTRTL          : 0x00400000,
    WS_EX_LEFT               : 0x00000000,
    WS_EX_LEFTSCROLLBAR      : 0x00004000,
    WS_EX_LTRREADING         : 0x00000000,
    WS_EX_MDICHILD           : 0x00000040,
    WS_EX_NOACTIVATE         : 0x08000000,
    WS_EX_NOINHERITLAYOUT    : 0x00100000,
    WS_EX_NOPARENTNOTIFY     : 0x00000004,
    WS_EX_OVERLAPPEDWINDOW   : 0x00000300,
    WS_EX_PALETTEWINDOW      : 0x00000188,
    WS_EX_RIGHT              : 0x00001000,
    WS_EX_RIGHTSCROLLBAR     : 0x00000000,
    WS_EX_RTLREADING         : 0x00002000,
    WS_EX_STATICEDGE         : 0x00020000,
    WS_EX_TOOLWINDOW         : 0x00000080,
    WS_EX_TOPMOST            : 0x00000008,
    WS_EX_TRANSPARENT        : 0x00000020,
    WS_EX_WINDOWEDGE         : 0x00000100,
    /*
    WM_CREATE                : 0x00000001,
    WM_CLOSE                 : 0x00000010,
    WM_QUIT                  : 0x00000012,
    WM_DESTROY               : 0x00000002,
    WM_COMMAND               : 0x00000111,
    WM_SYSCOMMAND            : 0x00000112,
    WM_MOUSEMOVE             : 0x00000200,
    WM_LBUTTONUP             : 0x00000202,
    WM_LBUTTONDOWN           : 0x00000201,
    WM_LBUTTONDBLCLK         : 0x00000203,
    WM_RBUTTONUP             : 0x00000205,
    WM_RBUTTONDOWN           : 0x00000204,
    WM_RBUTTONDBLCLK         : 0x00000206,
    WM_MBUTTONUP             : 0x00000208,
    WM_MBUTTONDOWN           : 0x00000207,
    WM_MBUTTONDBLCLK         : 0x00000209,
    WM_MOVE                  : 0x00000003,
    WM_SIZE                  : 0x00000005,
    WM_CHAR                  : 0x00000102,
    WM_KEYUP                 : 0x00000101,
    WM_KEYDOWN               : 0x00000100,
    WM_DROPFILES             : 0x00000233,
    WM_QUERYENDSESSION       : 0x00000011,
    WM_SETCURSOR             : 0x00000020,
    WM_SETFOCUS              : 0x00000007,
    WM_TIMER                 : 0x00000113,
    WM_USER                  : 0x00000400,
    WM_APP                   : 0x00008000,
    WM_PAINT                 : 0x0000000f,
    */
    WM_APP                   : 0x00008000,
    WM_ACTIVATE              : 0x00000006,
    WM_ACTIVATEAPP           : 0x0000001c,
    WM_AFXFIRST              : 0x00000360,
    WM_AFXLAST               : 0x0000037f,
    WM_ASKCBFORMATNAME       : 0x0000030c,
    WM_CANCELJOURNAL         : 0x0000004b,
    WM_CANCELMODE            : 0x0000001f,
    WM_CAPTURECHANGED        : 0x00000215,
    WM_CHANGECBCHAIN         : 0x0000030d,
    WM_CHAR                  : 0x00000102,
    WM_CHARTOITEM            : 0x0000002f,
    WM_CHILDACTIVATE         : 0x00000022,
    WM_CLEAR                 : 0x00000303,
    WM_CLOSE                 : 0x00000010,
    WM_COMMAND               : 0x00000111,
    WM_COMMNOTIFY            : 0x00000044,
    WM_COMPACTING            : 0x00000041,
    WM_COMPAREITEM           : 0x00000039,
    WM_CONTEXTMENU           : 0x0000007b,
    WM_COPY                  : 0x00000301,
    WM_COPYDATA              : 0x0000004a,
    WM_CREATE                : 0x00000001,
    WM_CTLCOLORBTN           : 0x00000135,
    WM_CTLCOLORDLG           : 0x00000136,
    WM_CTLCOLOREDIT          : 0x00000133,
    WM_CTLCOLORLISTBOX       : 0x00000134,
    WM_CTLCOLORMSGBOX        : 0x00000132,
    WM_CTLCOLORSCROLLBAR     : 0x00000137,
    WM_CTLCOLORSTATIC        : 0x00000138, // A static control, or an edit control that is read-only or disabled, sends the WM_CTLCOLORSTATIC  message to its parent window when the control is about to be drawn. By responding to this message, the parent window can use the specified device context handle to set the text and background colors of the static control.
    WM_CUT                   : 0x00000300,
    WM_DEADCHAR              : 0x00000103,
    WM_DELETEITEM            : 0x0000002d,
    WM_DESTROY               : 0x00000002,
    WM_DESTROYCLIPBOARD      : 0x00000307,
    WM_DEVICECHANGE          : 0x00000219,
    WM_DEVMODECHANGE         : 0x0000001b,
    WM_DISPLAYCHANGE         : 0x0000007e,
    WM_DRAWCLIPBOARD         : 0x00000308,
    WM_DRAWITEM              : 0x0000002b,
    WM_DROPFILES             : 0x00000233,
    WM_ENABLE                : 0x0000000a,
    WM_ENDSESSION            : 0x00000016,
    WM_ENTERIDLE             : 0x00000121,
    WM_ENTERMENULOOP         : 0x00000211,
    WM_ENTERSIZEMOVE         : 0x00000231,
    WM_ERASEBKGND            : 0x00000014,
    WM_EXITMENULOOP          : 0x00000212,
    WM_EXITSIZEMOVE          : 0x00000232,
    WM_FONTCHANGE            : 0x0000001d,
    WM_GETDLGCODE            : 0x00000087,
    WM_GETFONT               : 0x00000031,
    WM_GETHOTKEY             : 0x00000033,
    WM_GETICON               : 0x0000007f,
    WM_GETMINMAXINFO         : 0x00000024,
    WM_GETTEXT               : 0x0000000d,
    WM_GETTEXTLENGTH         : 0x0000000e,
    WM_HANDHELDFIRST         : 0x00000358,
    WM_HANDHELDLAST          : 0x0000035f,
    WM_HELP                  : 0x00000053,
    WM_HOTKEY                : 0x00000312,
    WM_HSCROLL               : 0x00000114,
    WM_HSCROLLCLIPBOARD      : 0x0000030e,
    WM_ICONERASEBKGND        : 0x00000027,
    WM_INITDIALOG            : 0x00000110,
    WM_INITMENU              : 0x00000116,
    WM_INITMENUPOPUP         : 0x00000117,
    WM_INPUTLANGCHANGE       : 0x00000051,
    WM_INPUTLANGCHANGEREQUEST: 0x00000050,
    WM_KEYDOWN               : 0x00000100,
    WM_KEYUP                 : 0x00000101,
    WM_KILLFOCUS             : 0x00000008,
    WM_MDIACTIVATE           : 0x00000222,
    WM_MDICASCADE            : 0x00000227,
    WM_MDICREATE             : 0x00000220,
    WM_MDIDESTROY            : 0x00000221,
    WM_MDIGETACTIVE          : 0x00000229,
    WM_MDIICONARRANGE        : 0x00000228,
    WM_MDIMAXIMIZE           : 0x00000225,
    WM_MDINEXT               : 0x00000224,
    WM_MDIREFRESHMENU        : 0x00000234,
    WM_MDIRESTORE            : 0x00000223,
    WM_MDISETMENU            : 0x00000230,
    WM_MDITILE               : 0x00000226,
    WM_MEASUREITEM           : 0x0000002c,
    WM_MENUCHAR              : 0x00000120,
    WM_MENUSELECT            : 0x0000011f,
    WM_NEXTMENU              : 0x00000213,
    WM_MOVE                  : 0x00000003,
    WM_MOVING                : 0x00000216,
    WM_NCACTIVATE            : 0x00000086,
    WM_NCCALCSIZE            : 0x00000083,
    WM_NCCREATE              : 0x00000081,
    WM_NCDESTROY             : 0x00000082,
    WM_NCHITTEST             : 0x00000084,
    WM_NCLBUTTONDBLCLK       : 0x000000a3,
    WM_NCLBUTTONDOWN         : 0x000000a1,
    WM_NCLBUTTONUP           : 0x000000a2,
    WM_NCMBUTTONDBLCLK       : 0x000000a9,
    WM_NCMBUTTONDOWN         : 0x000000a7,
    WM_NCMBUTTONUP           : 0x000000a8,
    WM_NCMOUSEMOVE           : 0x000000a0,
    WM_NCPAINT               : 0x00000085,
    WM_NCRBUTTONDBLCLK       : 0x000000a6,
    WM_NCRBUTTONDOWN         : 0x000000a4,
    WM_NCRBUTTONUP           : 0x000000a5,
    WM_NEXTDLGCTL            : 0x00000028,
    WM_NEXTMENU              : 0x00000213,
    WM_NOTIFY                : 0x0000004e,
    WM_NOTIFYFORMAT          : 0x00000055,
    WM_NULL                  : 0x00000000,
    WM_PAINT                 : 0x0000000f,
    WM_PAINTCLIPBOARD        : 0x00000309,
    WM_PAINTICON             : 0x00000026,
    WM_PALETTECHANGED        : 0x00000311,
    WM_PALETTEISCHANGING     : 0x00000310,
    WM_PARENTNOTIFY          : 0x00000210,
    WM_PASTE                 : 0x00000302,
    WM_PENWINFIRST           : 0x00000380,
    WM_PENWINLAST            : 0x0000038f,
    WM_POWER                 : 0x00000048,
    WM_POWERBROADCAST        : 0x00000218,
    WM_PRINT                 : 0x00000317,
    WM_PRINTCLIENT           : 0x00000318,
    WM_QUERYDRAGICON         : 0x00000037,
    WM_QUERYENDSESSION       : 0x00000011,
    WM_QUERYNEWPALETTE       : 0x0000030f,
    WM_QUERYOPEN             : 0x00000013,
    WM_QUEUESYNC             : 0x00000023,
    WM_QUIT                  : 0x00000012,
    WM_RENDERALLFORMATS      : 0x00000306,
    WM_RENDERFORMAT          : 0x00000305,
    WM_SETCURSOR             : 0x00000020,
    WM_SETFOCUS              : 0x00000007,
    WM_SETFONT               : 0x00000030,
    WM_SETHOTKEY             : 0x00000032,
    WM_SETICON               : 0x00000080,
    WM_SETREDRAW             : 0x0000000b,
    WM_SETTEXT               : 0x0000000c,
    WM_SETTINGCHANGE         : 0x0000001a,
    WM_SHOWWINDOW            : 0x00000018,
    WM_SIZE                  : 0x00000005,
    WM_SIZECLIPBOARD         : 0x0000030b,
    WM_SIZING                : 0x00000214,
    WM_SPOOLERSTATUS         : 0x0000002a,
    WM_STYLECHANGED          : 0x0000007d,
    WM_STYLECHANGING         : 0x0000007c,
    WM_SYSCHAR               : 0x00000106,
    WM_SYSCOLORCHANGE        : 0x00000015,
    WM_SYSCOMMAND            : 0x00000112,
    WM_SYSDEADCHAR           : 0x00000107,
    WM_SYSKEYDOWN            : 0x00000104,
    WM_SYSKEYUP              : 0x00000105,
    WM_TCARD                 : 0x00000052,
    WM_THEMECHANGED          : 0x0000031a,
    WM_TIMECHANGE            : 0x0000001e,
    WM_TIMER                 : 0x00000113,
    WM_UNDO                  : 0x00000304,
    WM_USER                  : 0x00000400,
    WM_USERCHANGED           : 0x00000054,
    WM_VKEYTOITEM            : 0x0000002e,
    WM_VSCROLL               : 0x00000115,
    WM_VSCROLLCLIPBOARD      : 0x0000030a,
    WM_WINDOWPOSCHANGED      : 0x00000047,
    WM_WINDOWPOSCHANGING     : 0x00000046,
    WM_WININICHANGE          : 0x0000001a,
    WM_KEYFIRST              : 0x00000100,
    WM_KEYLAST               : 0x00000108,
    WM_SYNCPAINT             : 0x00000088,
    WM_MOUSEACTIVATE         : 0x00000021,
    WM_MOUSEMOVE             : 0x00000200,
    WM_LBUTTONDOWN           : 0x00000201,
    WM_LBUTTONUP             : 0x00000202,
    WM_LBUTTONDBLCLK         : 0x00000203,
    WM_RBUTTONDOWN           : 0x00000204,
    WM_RBUTTONUP             : 0x00000205,
    WM_RBUTTONDBLCLK         : 0x00000206,
    WM_MBUTTONDOWN           : 0x00000207,
    WM_MBUTTONUP             : 0x00000208,
    WM_MBUTTONDBLCLK         : 0x00000209,
    WM_MOUSEWHEEL            : 0x0000020a,
    WM_MOUSEFIRST            : 0x00000200,
    WM_MOUSELAST             : 0x0000020a,
    WM_MOUSELAST             : 0x0000020a,
    WM_MOUSEHOVER            : 0x000002a1,
    WM_MOUSELEAVE            : 0x000002a3,
    
    TME_CANCEL               : 0x80000000,
    TME_HOVER                : 0x00000001,
    TME_LEAVE                : 0x00000002,
    TME_NONCLIENT            : 0x00000010,
    TME_QUERY                : 0x40000000,
    
    ICON_BIG                 : 1,
    ICON_SMALL               : 0,
    
    MK_CONTROL               : 0x0008,
    MK_LBUTTON               : 0x0001,
    MK_MBUTTON               : 0x0010,
    MK_RBUTTON               : 0x0002,
    MK_SHIFT                 : 0x0004,
    MK_XBUTTON1              : 0x0020,
    MK_XBUTTON2              : 0x0040,

    CW_USEDEFAULT            : 0x80000000
});

Object.inheritConstants(jls.win32.Window, _native.win32.Window);

/*
WC_BUTTON                : 'Button',
WC_STATIC                : 'Static',
WC_EDIT                  : 'Edit',
WC_LISTBOX               : 'ListBox',
WC_COMBOBOX              : 'ComboBox',
WC_SCROLLBAR             : 'ScrollBar',
WC_COMBOBOXEX            : 'ComboBoxEx32',
WC_HEADER                : 'SysHeader32',
WC_IPADDRESS             : 'SysIPAddress32',
WC_LISTVIEW              : 'SysListView32',
WC_TABCONTROL            : 'SysTabControl32',
WC_TREEVIEW              : 'SysTreeView32',
WC_PAGESCROLLER          : 'SysPager',
WC_NATIVEFONTCTL         : 'NativeFontCtl',
RICHEDIT_CLASS           : 'RichEdit20A',
PROGRESS_CLASS           : 'msctls_progress32',
TRACKBAR_CLASS           : 'msctls_trackbar32',
TOOLTIPS_CLASS           : 'tooltips_class32',
*/