jls.loader.provide('jls.win32.WindowElement');

jls.loader.require('jls.win32.Window');
jls.loader.require('jls.gui.Element');
jls.loader.require('jls.gui.Event');
jls.loader.require('jls.io.File');

jls.win32.WindowElement = jls.lang.Class.create(jls.gui.Element,
{
    initialize : function($super, parameters, parent) {
        this._window = null;
        this._windowId = null;
        this._windowUid = 1;
        this._bounds = [null, null, null, null];
        this._icon = null;
        this._menu = null;
        this._popupMenu = null;
        
        $super(parameters, parent);
        if (this._icon) {
            this.setIcon(this._icon);
        }
        jls.logger.trace('parent: "' + parent + '"');
        if ((typeof parent == 'undefined') || (parent == null)) {
            jls.win32.WindowElement._onCreateTopLevelWindow(this);
            this.observe('unload', jls.win32.WindowElement._onDestroyTopLevelWindow);
        }
        // TODO Remove
        //this._window.show(jls.win32.Window.SW_SHOW);
        //this.observe('load', this._window.update.bind(this));
        //this._window.update();
    },
    onCreate : jls.lang.Class.abstractMethod,
    onStyleChange : function(key, oldValue, newValue) {
        if (this._window == null) {
            return;
        }
        switch (key) {
        case 'fontFamily':
        case 'fontSize':
            var font = jls.win32.WindowElement.getFont(this.getStyle().getPropertyValue('fontFamily'),
            		this.getStyle().getPropertyValue('fontSize'));
            this._window.sendMessage(jls.win32.Window.WM_SETFONT, font, 1 /* force redraw */);
            break;
        case 'visibility':
        	//this._element._window.isWindowVisible() ? 'visible' : 'hidden';
    		//jls.lang.System.out.println('onStyleChange(' + key + ', ' + oldValue + ', ' + newValue + ')');
            this._window.show(newValue == 'visible' ? jls.win32.Window.SW_SHOW : jls.win32.Window.SW_HIDE);
            break;
        default:
            return;
        }
    },
    addChild : function($super, child) {
    	/*if ((typeof child == 'object') &&
    			(child instanceof jls.win32.WindowElement) &&
    			(child.getWindowStyle() & jls.win32.Window.WS_CHILD == jls.win32.Window.WS_CHILD)) {
    		return;
    	}*/
    	if ((typeof child == 'object') && (child instanceof jls.win32.Frame)) {
    		return child;
    	}
    	return $super(child);
    },
    onDestroy : function() {
        this._window.close();
    },
    getParentWindow : function(native) {
        var parent = this.getParent();
        // Looking for the first window type parent
        while (parent) {
            if (parent instanceof jls.win32.WindowElement) {
            	if (native) {
                    return parent._window;
            	} else {
                    return parent;
            	}
            }
            parent = parent.getParent();
        }
        return null;
    },
    getWindowOffset : function() {
        var parent = this.getParent();
        var x = 0;
        var y = 0;
        // Looking for the first window type parent
        while (parent) {
        	var cOffset = parent.getClientOffset();
            x += cOffset[0];
            y += cOffset[1];
            if (parent instanceof jls.win32.WindowElement) {
                return [x, y];
            }
            x += parent._x;
            y += parent._y;
            parent = parent.getParent();
        }
        throw new jls.lang.Exception('No WindowElement parent found');
    },
    getOwnedWindows : function() {
        return [];
    },
    observe: function($super, type, handler) {
    	$super(type, handler);
    	if (type == 'mouseout') {
    		//this._window.trackMouseEvent(jls.win32.Window.TME_LEAVE);
    		this._window.setCapture();
    	}
    },
    unobserve: function($super, type, handler) {
    	$super(type, handler);
    	if (type == 'mouseout') {
        	//jls.logger.warn('releaseCapture()');
    		jls.win32.Window.releaseCapture();
    	}
    },
    onWindowMessage: function(message, wParam, lParam) {
    	//jls.logger.warn('onWindowMessage(' + jls.win32.Window.getMessageName(message) + ', ' + wParam + ', ' + lParam + ')');
        switch(message) {
        case jls.win32.Window.WM_CREATE:
            this.dispatch(new jls.gui.Event('load', this));
            break;
        case jls.win32.Window.WM_DESTROY:
            this.dispatch(new jls.gui.Event('unload', this));
            break;
        case jls.win32.Window.WM_INITMENU: // a menu is about to become active.
            // wParam: A handle to the menu to be initialized.
            var menu = null;
            if ((this._popupMenu != null) && (this._popupMenu._menu.handle() == wParam)) {
            	menu = this._popupMenu;
            }
            if ((this._menu != null) && (this._menu._menu.handle() == wParam)) {
            	menu = this._menu;
            }
            if (menu != null) {
            	menu.dispatch(new jls.gui.Event('init', this));
            }
            break;
        case jls.win32.Window.WM_INITMENUPOPUP: // a drop-down menu or submenu is about to become active
            break;
        case jls.win32.Window.WM_COMMAND:
        	var src = jls.win32.Window.hiWord(wParam);
        	var id = jls.win32.Window.loWord(wParam);
        	//jls.logger.warn('WM_COMMAND wParam: ' + wParam + ' (src: ' + src + ', id: ' + id + '), lParam: ' + lParam);
        	if (src == 0) { // Menu
        		var item = null;
                if (this._menu != null) {
                	item = this._menu.getItemById(id);
                }
                if ((item == null) && (this._popupMenu != null)) {
                	item = this._popupMenu.getItemById(id);
                }
        		if ((item != null) && (item._event != null)) {
        	        var event = new jls.gui.Event(item._event, this);
        	        event.menuItem = item;
        	        item.getRootMenu().dispatch(event);
        		}
        	} else if (src == 1) { // Accelerator
        	}/* else { // Control
        		// lParam contains the control handle
                var childCount = this.getChildCount();
                for (var i = 0; i < childCount; i++) {
                    var child = this.getChild(i);
                    if ((child instanceof jls.win32.WindowElement) &&
                    		((child._windowId == id) || (child._window.handle() == lParam)) &&
                    		('onWindowCommand' in child))
                    {
                        child.onWindowCommand(src);
                        break;
                    }
                }
        	}*/ // Control notifications are routed natively on the control window via WM_CTLNOTIFY
            break;
        case jls.win32.Window.WM_SIZE:
            var event = new jls.gui.Event('resize', this);
            event.width = jls.win32.Window.loWord(lParam);
            event.height = jls.win32.Window.hiWord(lParam);
            //jls.logger.trace('WM_SIZE - wParam: ' + wParam + ', lParam: ' + lParam + ' (' + event.width + 'x' + event.height + ')');
            this.dispatch(event);
            break;
        case jls.win32.Window.WM_SETFOCUS:
            this.dispatch(new jls.gui.Event('focus', this));
            break;
        case jls.win32.Window.WM_LBUTTONDOWN:
            this.dispatch(jls.win32.WindowElement.createMouseEvent('mousedown', this, jls.gui.Event.MOUSE_BUTTON_LEFT, wParam, lParam));
            break;
        case jls.win32.Window.WM_LBUTTONUP:
            this.dispatch(jls.win32.WindowElement.createMouseEvent('mouseup', this, jls.gui.Event.MOUSE_BUTTON_LEFT, wParam, lParam));
            this.dispatch(jls.win32.WindowElement.createMouseEvent('click', this, jls.gui.Event.MOUSE_BUTTON_LEFT, wParam, lParam));
            break;
        case jls.win32.Window.WM_LBUTTONDBLCLK:
            this.dispatch(jls.win32.WindowElement.createMouseEvent('dblclick', this, jls.gui.Event.MOUSE_BUTTON_LEFT, wParam, lParam));
            break;
        case jls.win32.Window.WM_MBUTTONDOWN:
            this.dispatch(jls.win32.WindowElement.createMouseEvent('mousedown', this, jls.gui.Event.MOUSE_BUTTON_MIDDLE, wParam, lParam));
            break;
        case jls.win32.Window.WM_MBUTTONUP:
            this.dispatch(jls.win32.WindowElement.createMouseEvent('mouseup', this, jls.gui.Event.MOUSE_BUTTON_MIDDLE, wParam, lParam));
            this.dispatch(jls.win32.WindowElement.createMouseEvent('click', this, jls.gui.Event.MOUSE_BUTTON_MIDDLE, wParam, lParam));
            break;
        case jls.win32.Window.WM_MBUTTONDBLCLK:
            this.dispatch(jls.win32.WindowElement.createMouseEvent('dblclick', this, jls.gui.Event.MOUSE_BUTTON_MIDDLE, wParam, lParam));
            break;
        case jls.win32.Window.WM_RBUTTONDOWN:
            this.dispatch(jls.win32.WindowElement.createMouseEvent('mousedown', this, jls.gui.Event.MOUSE_BUTTON_RIGHT, wParam, lParam));
            break;
        case jls.win32.Window.WM_RBUTTONUP:
            this.dispatch(jls.win32.WindowElement.createMouseEvent('mouseup', this, jls.gui.Event.MOUSE_BUTTON_RIGHT, wParam, lParam));
            this.dispatch(jls.win32.WindowElement.createMouseEvent('click', this, jls.gui.Event.MOUSE_BUTTON_RIGHT, wParam, lParam));
            break;
        case jls.win32.Window.WM_RBUTTONDBLCLK:
            this.dispatch(jls.win32.WindowElement.createMouseEvent('dblclick', this, jls.gui.Event.MOUSE_BUTTON_RIGHT, wParam, lParam));
            break;
        // TODO mouseover
        case jls.win32.Window.WM_MOUSEMOVE:
            this.dispatch(jls.win32.WindowElement.createMouseEvent('mousemove', this, -1, wParam, lParam));
            break;
        case jls.win32.Window.WM_MOUSELEAVE: // TODO Remove
        case jls.win32.Window.WM_CAPTURECHANGED:
            this.dispatch(jls.gui.Event.createKeyEvent('mouseout', this, ' '));
            break;
        case jls.win32.Window.WM_KEYDOWN:
            this.dispatch(jls.gui.Event.createKeyEvent('keydown', this, ' '));
            break;
        case jls.win32.Window.WM_KEYUP:
            this.dispatch(jls.gui.Event.createKeyEvent('keyup', this, ' '));
            break;
        }
    },
    onStartObserving: function() {
        this._window.setWindowFunction(this.onWindowMessage.bind(this));
    },
    onStopObserving: function() {
        this._window.setWindowFunction(null);
    },
    setMenu : function(menu) {
    	if (! (menu instanceof jls.win32.MenuItem)) {
    		throw new jls.lang.Exception('Invalid menu argument');
    	}
        this._menu = menu;
        this._window.setMenu(menu._menu);
    },
    trackPopup : function(popupMenu, x, y) {
    	if (! (popupMenu instanceof jls.win32.MenuItem)) {
    		throw new jls.lang.Exception('Invalid popupMenu argument');
    	}
        this._popupMenu = popupMenu;
        return popupMenu._menu.trackPopup(this._window, x, y);
    },
    getWindowExStyle : function() {
        var exs = 0;
        // TODO 
    	/*if (this.getStyle().getPropertyValue('border') != null) {
            exs |= jls.win32.Window.WS_EX_CLIENTEDGE
        }*/
        return exs;
    },
    getWindowStyle : function() {
    	var ws = jls.win32.Window.WS_CHILD;
    	if (this.getStyle().getPropertyValue('visibility') == 'visible') {
    		ws |= jls.win32.Window.WS_VISIBLE;
    	}
        // TODO Fix
    	if (this.getStyle().getPropertyValue('border') != null) {
    		ws |= jls.win32.Window.WS_BORDER;
    	}
    	if (this.getStyle().getPropertyValue('overflow') == 'scroll') {
    		ws |= jls.win32.Window.WS_HSCROLL | jls.win32.Window.WS_VSCROLL;
    	}
        return ws;
    },
    getWindowId : function(create) {
    	if (create) {
    		var pw = this.getParentWindow();
    		if ((pw != null)) {
    			this._windowId = pw._windowUid++;
    		}
    	}
        return this._windowId;
    },
    setWindowId : function(id) {
        this._windowId = id;
        return this;
    },
    /*setWindowExStyle : function(exStyle) {
        this._windowExStyle = exStyle;
        return this;
    },
    setWindowStyle : function(style) {
        this._windowStyle = style;
        return this;
    },*/
    // TODO setWindowIcon ?
    getIcon : function() {
        return this._icon;
    },
    setIcon : function(name) {
        var icon = jls.win32.WindowElement.getIcon(name);
        if (icon) {
            this._icon = name;
            if (this._window) {
                this._window.setIcon(icon);
            }
        }
        return this;
    },
    /*setWindowFont : function(font) {
        this.sendMessage(jls.win32.Window.WM_SETFONT, font, 0);
        return this;
    },*/
    onWindowUpdate : function() {
    	var offset = this.getWindowOffset();
        var bounds = this.getBounds();
        var locationChange = (offset[0] + bounds[0] != this._bounds[0]) || (offset[1] + bounds[1] != this._bounds[1]);
        var sizeChange = (bounds[2] != this._bounds[2]) || (bounds[3] != this._bounds[3]);
        if (locationChange || sizeChange) {
            this._setPos(locationChange == sizeChange ? 0 : (locationChange ? jls.win32.Window.SWP_NOSIZE : jls.win32.Window.SWP_NOMOVE));
        }
    },
    update : function($super) {
    	this.onWindowUpdate();
        $super();
        return this;
    },
    _setPos : function(flag, offset) {
        if (this._window) {
        	offset = offset || this.getWindowOffset();
            this._window.setPosition(offset[0] + this.getX(), offset[1] + this.getY(), this.getW(), this.getH(), flag || 0);
            this._bounds = [offset[0] + this.getX(), offset[1] + this.getY(), this.getW(), this.getH()];
        }
    },
    _getBounds : function() {
        var rect = this._window.rect(true);
        return [rect[0], rect[1], rect[2] - rect[0], rect[3] - rect[1]];
    },
    _getClientRect : function() {
        return this._window.rect(true);
    }
});

Object.extend(jls.win32.WindowElement,
{
    _topLevelWindowCount : 0,
    _topLevelWindows : [],
    _fontCache : {},
    _iconCache : {},
    getFont : function(family, size) {
        var key = family + '#' + size;
        //jls.logger.warn('key: "' + key + '"');
        if (! (key in jls.win32.WindowElement._fontCache)) {
            jls.win32.WindowElement._fontCache[key] = new jls.win32.Font(family, size);
        }
        return jls.win32.WindowElement._fontCache[key];
    },
    getIcon : function(iconFilename) {
        if (! (iconFilename in jls.win32.WindowElement._iconCache)) {
            if (new jls.io.File(iconFilename).exists()) {
                jls.win32.WindowElement._iconCache[iconFilename] = new jls.win32.Image(iconFilename, jls.win32.Image.IMAGE_ICON);
            } else {
                jls.logger.debug('File not found ' + iconFilename);
                //throw new jls.lang.Exception('File not found ' + iconFilename);
            }
        }
        return jls.win32.WindowElement._iconCache[iconFilename];
    },
    createMouseEvent : function(type, target, button, wParam, lParam) {
        var event = new jls.gui.Event(type, target);
        event.setMouse(button, jls.win32.Window.loWord(lParam), jls.win32.Window.hiWord(lParam), 0, 0);
        event.control = (wParam & jls.win32.Window.MK_CONTROL) != 0;
        event.shift = (wParam & jls.win32.Window.MK_SHIFT) != 0;
        return event;
    },
    getWindows : function() {
        // TODO make a copy
        return jls.win32.WindowElement._topLevelWindows;
    },
    _onCreateTopLevelWindow : function(wnd) {
        jls.win32.WindowElement._topLevelWindowCount++;
        jls.logger.trace('add top-level window (' + jls.win32.WindowElement._topLevelWindowCount + ')');
    },
    _onDestroyTopLevelWindow : function(event) {
        
        jls.win32.WindowElement._topLevelWindowCount--;
        jls.logger.trace('remove top-level window (' + jls.win32.WindowElement._topLevelWindowCount + ')');
        if (jls.win32.WindowElement._topLevelWindowCount == 0) {
            jls.win32.Window.destroyThreadWindow();
        }
    }
});

