/*
 * prototype.js light
 */
Array.prototype.clone = function() {
  return [].concat(this);
};
Array.prototype.toArray = Array.prototype.clone;
// The primary use of Array.from() is to obtain an actual Array object based on anything that could pass as an array.
// the predefined arguments reference within your functions
Array.from = function(iterable) {
  if (!iterable) return [];
  if (iterable.toArray) return iterable.toArray();
  var length = iterable.length || 0, results = new Array(length);
  while (length--) results[length] = iterable[length];
  return results;
}
// extend Object
Object.extend = function(destination, source) {
  for (var property in source)
    destination[property] = source[property];
  return destination;
};
Object.extend(Object, {
  toJSON: function(object) {
    var type = typeof object;
    switch (type) {
      case 'undefined':
      case 'function':
      case 'unknown': return;
      case 'boolean': return object.toString();
    }
    if (object === null) return 'null';
    if (object.toJSON) return object.toJSON();
    var results = [];
    for (var property in object) {
      var value = Object.toJSON(object[property]);
      if (!Object.isUndefined(value))
        results.push(property.toJSON() + ': ' + value);
    }
    return '{' + results.join(', ') + '}';
  },
  keys: function(object) {
    var keys = [];
    for (var property in object)
      keys.push(property);
    return keys;
  },
  values: function(object) {
    var values = [];
    for (var property in object)
      values.push(object[property]);
    return values;
  },
  isArray: function(object) {
    return object != null && typeof object == "object" &&
      'splice' in object && 'join' in object;
  },
  isHash: function(object) {
    return object instanceof Hash;
  },
  isFunction: function(object) {
    return typeof object == "function";
  },
  isString: function(object) {
    return typeof object == "string";
  },
  isNumber: function(object) {
    return typeof object == "number";
  },
  isUndefined: function(object) {
    return typeof object == "undefined";
  },
  inheritConstants: function(destination, source) {
    for (var property in source) {
      if ((typeof source[property] == "string") || (typeof source[property] == "number")) {
          destination[property] = source[property];
      }
    }
    return destination;
  }
});
// extend Function
Object.extend(Function.prototype, {
  argumentNames: function() {
    var names = this.toString().match(/^[\s\(]*function[^(]*\(([^\)]*)\)/)[1]
      .replace(/\s+/g, '').split(',');
    return names.length == 1 && !names[0] ? [] : names;
  },
  bind: function() {
    if (arguments.length < 2 && (typeof arguments[0] == "undefined")) return this;
    var __method = this, args = Array.from(arguments), object = args.shift();
    return function() {
      return __method.apply(object, args.concat(Array.from(arguments)));
    }
  },
  curry: function() {
    if (!arguments.length) return this;
    var __method = this, args = Array.from(arguments);
    return function() {
      return __method.apply(this, args.concat(Array.from(arguments)));
    }
  },
  wrap: function(wrapper) {
    var __method = this;
    return function() {
      return wrapper.apply(this, [__method.bind(this)].concat(Array.from(arguments)));
    }
  },
  methodize: function() {
    if (this._methodized) return this._methodized;
    var __method = this;
    return this._methodized = function() {
      return __method.apply(null, [this].concat(Array.from(arguments)));
    };
  }
});
Object.extend(String.prototype, {
  camelize: function(prefix, suffix) {
    var parts = this.split('-');
    if (prefix) parts.unshift(prefix);
    if (suffix) parts.push(suffix);
    var len = parts.length;
    if (len == 1) return parts[0];

    var camelized = this.charAt(0) == '-'
      ? parts[0].charAt(0).toUpperCase() + parts[0].substring(1)
      : parts[0];

    for (var i = 1; i < len; i++)
      camelized += parts[i].charAt(0).toUpperCase() + parts[i].substring(1);

    return camelized;
  },
  capitalize: function() {
    return this.charAt(0).toUpperCase() + this.substring(1).toLowerCase();
  },
  startsWith: function(pattern) {
    return this.indexOf(pattern) === 0;
  },
  endsWith: function(pattern) {
    var d = this.length - pattern.length;
    return d >= 0 && this.lastIndexOf(pattern) === d;
  },
  empty: function() {
    return this == '';
  },
  strip: function() {
    return this.replace(/^\s+/, '').replace(/\s+$/, '');
  },
  // TODO Remove this
  times: function(count) {
    return count < 1 ? '' : new Array(count + 1).join(this);
  },
  toJSON: function() {
    // TODO Fix quotes...
    return '\'' + this.toString().replace(/([\\'])/g, '\\$1') + '\'';
  }
});
Object.extend(Number.prototype, {
  toPaddedString: function(length, radix) {
    var string = this.toString(radix || 10);
    return '0'.times(length - string.length) + string;
  },
  toJSON: function() {
    return isFinite(this) ? this.toString() : 'null';
  }
});
Object.extend(Array.prototype, {
  indexOf: function(object, from) {
    var len = this.length;
    from = from || 0;
    for (var i = from; i < len; i++) {
      if (this[i] === object) {
        return i;
      }
    }
    return -1;
  },
  remove: function(object) {
    var index = 0;
    if (typeof object == 'number') {
      index = object;
    } else {
      index = this.indexOf(object);
      if (index < 0) {
        return null;
      }
    }
    return this.splice(index, 1)[0];
  },
  toJSON: function() {
    var results = [];
    for (var i = 0, length = this.length; i < length; i++) {
    //this.each(function(object) {
      var value = Object.toJSON(this[i]);
      if (!Object.isUndefined(value)) results.push(value);
    };
    return '[' + results.join(', ') + ']';
  }
});
Object.extend(Date.prototype, {
  // TODO Fix UTC
  toJSON: function() {
    return '"' + this.getUTCFullYear() + '-' +
      (this.getUTCMonth() + 1).toPaddedString(2) + '-' +
      this.getUTCDate().toPaddedString(2) + 'T' +
      this.getUTCHours().toPaddedString(2) + ':' +
      this.getUTCMinutes().toPaddedString(2) + ':' +
      this.getUTCSeconds().toPaddedString(2) + 'Z"';
  }
});
/**
 * @class Class like creation with inheritance. Based on Alex Arnell's inheritance implementation.
 */
jls.lang.Class = {/** @lends jls.lang.Class */
    /**
     * Creates a new class.
     * 
     * @param {Object} declaration An object containing the class declaration.
     * @returns {Object} The new class.
     */
  create: function() {
    var parent = null, properties = Array.from(arguments);
    if (typeof properties[0] == "function")
      parent = properties.shift();

    function klass() {
      this.initialize.apply(this, arguments);
    }

    Object.extend(klass, jls.lang.Class.Methods);
    klass.superclass = parent;
    klass.subclasses = [];

    if (parent) {
      var subclass = function() { };
      subclass.prototype = parent.prototype;
      klass.prototype = new subclass;
      parent.subclasses.push(klass);
    }

    for (var i = 0; i < properties.length; i++)
      klass.addMethods(properties[i]);

    if (!klass.prototype.initialize)
      klass.prototype.initialize = jls.lang.Class.emptyFunction;

    klass.prototype.constructor = klass;

    return klass;
  },
  emptyFunction: function() { },
  notAvailableFunction: function() {
      throw new jls.lang.Exception('Function not available');
  },
  abstractMethod: function() {
      throw new jls.lang.Exception('Abstract method');
  },
  // instantiate
  newInstance: function(object) {
    if (!(object && object.classname)) {
      throw new jls.lang.Exception('Invalid object, the classname property is required');
    }
    var classname = object.classname;
    jls.loader.require(classname);
    /*var properties = Array.from(arguments);
    var args = '';
    for (var i = 0; i < properties.length; i++) {
      if (i > 0) args += ', ';
      args += 'properties[' + i + ']';
    }*/
    var args = 'object';
    for (var i = 1; i < arguments.length; i++) {
      args += ', arguments[' + i + ']';
    }
    //jls.logger.info('newInstance() : eval(\'new ' + classname + '(' + args + ')\')');
    return eval('new ' + classname + '(' + args + ')');
  }
};
/**
 * @class Class helper.
 */
jls.lang.Class.Methods = /** @lends jls.lang.Class.Methods */
{
  addMethods: function(source) {
    var ancestor   = this.superclass && this.superclass.prototype;
    var properties = Object.keys(source);

    if (!Object.keys({ toString: true }).length)
      properties.push("toString", "valueOf");

    for (var i = 0, length = properties.length; i < length; i++) {
      var property = properties[i], value = source[property];
      if (ancestor && (typeof value == 'function') &&
          value.argumentNames()[0] == "$super") {
        var method = value;
        value = (function(m) {
          return function() { return ancestor[m].apply(this, arguments) };
        })(property).wrap(method);

        value.valueOf = method.valueOf.bind(method);
        value.toString = method.toString.bind(method);
      }
      this.prototype[property] = value;
    }

    return this;
  }
};
