jls.loader.provide('jls.jsunit.AssertTest');

jls.loader.require('jls.jsunit.TestCase');
jls.loader.require('jls.jsunit.Assert');

jls.jsunit.AssertTest = jls.lang.Class.create(jls.jsunit.TestCase,
{
    checkFailure : function(fn, msg) {
        var f = null;
        try {
            fn();
        } catch (e) {
            f = e;
        }
        jls.jsunit.Assert.assertNotNull(f);
        jls.jsunit.Assert.assertTrue(f instanceof jls.lang.AssertionError);
        jls.jsunit.Assert.assertEquals(msg, f.getMessage());
    },
    testAssertTrue : function() {
        jls.jsunit.Assert.assertTrue(true);
        this.checkFailure(function() {
            jls.jsunit.Assert.assertTrue(false);
        }, null);
        this.checkFailure(function() {
            jls.jsunit.Assert.assertTrue(false, 'Ooops');
        }, 'Ooops');
    },
    testAssertFalse : function() {
        jls.jsunit.Assert.assertFalse(false);
        this.checkFailure(function() {
            jls.jsunit.Assert.assertFalse(true, 'Ooops');
        }, 'Ooops');
    },
    testAssertEquals : function() {
        jls.jsunit.Assert.assertEquals(1, 1);
        this.checkFailure(function() {
            jls.jsunit.Assert.assertEquals(1, 2, 'Ooops');
        }, 'Ooops expected:<1> but was:<2>');
    },
    testAssertNull : function() {
        jls.jsunit.Assert.assertNull(null);
        this.checkFailure(function() {
            jls.jsunit.Assert.assertNull(this, 'Ooops');
        }, 'Ooops');
    },
    testAssertNotNull : function() {
        jls.jsunit.Assert.assertNotNull(this);
        this.checkFailure(function() {
            jls.jsunit.Assert.assertNotNull(null, 'Ooops');
        }, 'Ooops');
    },
    testAssertSame : function() {
        var obj = {};
        jls.jsunit.Assert.assertSame(obj, obj);
        this.checkFailure(function() {
            jls.jsunit.Assert.assertSame(1, {}, 'Ooops');
        }, 'Ooops expected same:<1> was not:<[object Object]>');
    },
    testAssertNotSame : function() {
        var obj = {};
        jls.jsunit.Assert.assertNotSame(1, this);
        this.checkFailure(function() {
            jls.jsunit.Assert.assertNotSame(obj, obj, 'Ooops');
        }, 'Ooops expected not same');
    }
});

