﻿jls.loader.provide('jls.lang.ByteBufferTest');

jls.loader.require('jls.jsunit.TestCase');
jls.loader.require('jls.jsunit.Assert');
jls.loader.require('jls.lang.ByteBuffer');

jls.lang.ByteBufferTest = jls.lang.Class.create(jls.jsunit.TestCase,
{
    testByte : function() {
        jls.lang.ByteBufferTest.testInt('Byte', true, [0, 1, 2, 12, 78, 123, 127]);
        jls.lang.ByteBufferTest.testInt('Byte', true, [-1, -2, -12, -78, -100, -128]);
        jls.lang.ByteBufferTest.testInt('Byte', true, [128, 255, 256], [-128, -1, 0]);
    },
    testUnsignedByte : function() {
        jls.lang.ByteBufferTest.testInt('Byte', false, [0, 1, 2, 12, 78, 123, 127]);
        jls.lang.ByteBufferTest.testInt('Byte', false, [128, 161, 200, 212, 255]);
        jls.lang.ByteBufferTest.testInt('Byte', false, [-128, -1, 256], [128, 255, 0]);
    },
    testShort : function() {
        jls.lang.ByteBufferTest.testInt('Short', true, [0, 1, 2, 12, 78, 123, 127]);
        jls.lang.ByteBufferTest.testInt('Short', true, [128, 161, 200, 212, 255]);
        jls.lang.ByteBufferTest.testInt('Short', true, [256, 510, 4000, 32000, 32767]);
        jls.lang.ByteBufferTest.testInt('Short', true, [-1, -2, -12, -78, -100, -128]);
        jls.lang.ByteBufferTest.testInt('Short', true, [-129, -255, -256, -510, -32000, -32768]);
    },
    testUnsignedShort : function() {
        jls.lang.ByteBufferTest.testInt('Short', false, [0, 1, 2, 12, 78, 123, 127]);
        jls.lang.ByteBufferTest.testInt('Short', false, [128, 161, 200, 212, 255]);
        jls.lang.ByteBufferTest.testInt('Short', false, [256, 510, 4000, 32000, 32767]);
        jls.lang.ByteBufferTest.testInt('Short', false, [40000, 51111, 65535]);
    },
    testLong : function() {
        jls.lang.ByteBufferTest.testInt('Long', true, [0, 1, 2, 12, 78, 123, 127]);
        jls.lang.ByteBufferTest.testInt('Long', true, [128, 161, 200, 212, 255]);
        jls.lang.ByteBufferTest.testInt('Long', true, [256, 510, 4000, 32000, 32767]);
        jls.lang.ByteBufferTest.testInt('Long', true, [40000, 51111, 65535]);
        jls.lang.ByteBufferTest.testInt('Long', true, [-1, -2, -12, -78, -100, -128]);
        jls.lang.ByteBufferTest.testInt('Long', true, [-129, -255, -256, -510, -32000, -32768]);
        jls.lang.ByteBufferTest.testInt('Long', true, [-40000, -51111, -65535, -70000]);
    },
    testUnsignedLong : function() {
        jls.lang.ByteBufferTest.testInt('Long', false, [0, 1, 2, 12, 78, 123, 127]);
        jls.lang.ByteBufferTest.testInt('Long', false, [128, 161, 200, 212, 255]);
        jls.lang.ByteBufferTest.testInt('Long', false, [256, 510, 4000, 32000, 32767]);
        jls.lang.ByteBufferTest.testInt('Long', false, [40000, 51111, 65535]);
        jls.lang.ByteBufferTest.testInt('Long', false, [70000]);
    },
    testPosition : function() {
        var buffer = jls.lang.ByteBuffer.allocate(10);
        jls.jsunit.Assert.assertEquals(0, buffer.position());
        buffer.putByte(1);
        jls.jsunit.Assert.assertEquals(1, buffer.position());
        buffer.putByte(2);
        jls.jsunit.Assert.assertEquals(2, buffer.position());
        buffer.flip();
        jls.jsunit.Assert.assertEquals(0, buffer.position());
    },
    testRemaining : function() {
        var buffer = jls.lang.ByteBuffer.allocate(10);
        jls.jsunit.Assert.assertEquals(10, buffer.remaining());
        buffer.putByte(1);
        jls.jsunit.Assert.assertEquals(9, buffer.remaining());
        buffer.putByte(2);
        jls.jsunit.Assert.assertEquals(8, buffer.remaining());
        buffer.flip();
        jls.jsunit.Assert.assertEquals(2, buffer.remaining());
    },
    testString : function() {
        var buffer = jls.lang.ByteBuffer.allocate(10);
        var text = 'Déjà !';
        var expected = 'D?j? !';
        var charsetName = 'ASCII';
        buffer.putString(text, charsetName);
        buffer.flip();
        var result = buffer.getString(charsetName);
        jls.jsunit.Assert.assertEquals(expected, result);
    },
    testMemcpy : function() {
        var b1 = jls.lang.ByteBuffer.allocate(10);
        var b2 = jls.lang.ByteBuffer.allocate(10);
        var ta = [0x01, 0xef, 0x3d, 0x12, 0x61, 0x20, 0x88];
        for (var i = 0; i < ta.length; i++) {
            b1.putByte(ta[i]);
        }
        b1.flip();
        jls.jsunit.Assert.assertEquals(ta.length, b1.remaining());
        var b3 = b1.slice();
        for (var i = 0; i < ta.length; i++) {
            jls.jsunit.Assert.assertEquals(ta[i], b3.getByte());
        }
        b2.putBuffer(b1);
        b2.flip();
        jls.jsunit.Assert.assertEquals(ta.length, b2.remaining());
        for (var i = 0; i < ta.length; i++) {
            jls.jsunit.Assert.assertEquals(ta[i], b2.getByte());
        }
    }
});

Object.extend(jls.lang.ByteBufferTest,
{
    testInt : function(methodName, signed, values, results) {
        results = results || values;
        var buffer = jls.lang.ByteBuffer.allocate(100);
        var orders = [jls.lang.Buffer.BIG_ENDIAN, jls.lang.Buffer.LITTLE_ENDIAN];
        for (var j = 0; j < orders.length; j++) {
            buffer.setByteOrder(orders[j]);
            for (var i = 0; i < values.length; i++) {
                buffer.clear();
                buffer['put' + methodName](values[i]);
                buffer.flip();
                var result = buffer['get' + methodName](signed);
                jls.jsunit.Assert.assertTrue(result == results[i], jls.lang.ByteBufferTest.printError(results[i], result));
            }
        }
    },
    printError : function(expected, result) {
        return 'Bad value, expected: ' + expected + '(0x' + expected.toString(16) + ') != ' + result + '(0x' + result.toString(16) + ')';
    }
});

