jls.loader.provide('jls.lang.StructTest');

jls.loader.require('jls.jsunit.TestCase');
jls.loader.require('jls.jsunit.Assert');
jls.loader.require('jls.lang.Struct');

jls.lang.StructTest = jls.lang.Class.create(jls.jsunit.TestCase,
{
    testInteger : function() {
        var s = new jls.lang.Struct([
            {name: 'a', type: 'SignedByte', length: 1},
            {name: 'b', type: 'UnsignedByte', length: 1},
            {name: 'c', type: 'SignedShort', length: 1},
            {name: 'd', type: 'UnsignedShort', length: 1},
            {name: 'e', type: 'SignedInt', length: 1},
            {name: 'f', type: 'UnsignedInt', length: 1},
            {name: 'g', type: 'SignedLong', length: 1},
            {name: 'h', type: 'UnsignedLong', length: 1}
        ]);
        jls.jsunit.Assert.assertEquals((1 + 2 + 4 + 8) * 2, s.buffer().capacity(), 'Bad buffer capacity');
        
        //s.buffer().setByteOrder(jls.lang.Buffer.LITTLE_ENDIAN);
        //s.buffer().setByteOrder(jls.lang.Buffer.BIG_ENDIAN);
        s.put('a', -1);
        s.put('b', 1);
        s.put('c', -2);
        s.put('d', 2);
        s.put('e', -3);
        s.put('f', 3);
        s.put('g', -4);
        s.put('h', 4);

        var structDump = '';
        s.buffer().setPosition(0);
        for (var i = 0; i < s.buffer().capacity(); i++) {
            var b = s.buffer().getByte();
            structDump += ' ' + (b < 16 ? '0' : '') + b.toString(16);
        }
        
        jls.jsunit.Assert.assertEquals(-1, s.get('a'));
        jls.jsunit.Assert.assertEquals(1, s.get('b'));
        jls.jsunit.Assert.assertEquals(-2, s.get('c'));
        jls.jsunit.Assert.assertEquals(2, s.get('d'));
        jls.jsunit.Assert.assertEquals(-3, s.get('e'));
        jls.jsunit.Assert.assertEquals(3, s.get('f'));
        jls.jsunit.Assert.assertEquals(-4, s.get('g'));
        jls.jsunit.Assert.assertEquals(4, s.get('h'));
    }
});

