jls.loader.provide('jls.util.CookieTest');

jls.loader.require('jls.jsunit.TestCase');
jls.loader.require('jls.util.Cookie');

jls.util.CookieTest = jls.lang.Class.create(jls.jsunit.TestCase,
{
    testSetGet : function() {
        var name = 'testSetGet';
        var value = 'Hello testSetGet !';
        
        jls.util.Cookie.set(name, value);
        var result = jls.util.Cookie.get(name);
        
        jls.jsunit.Assert.assertEquals(result, value);
    },
    testAll : function() {
        jls.util.Cookie.clear('testClear1');
        jls.util.Cookie.set('testClear2', 'a value');
        jls.util.Cookie.set('testClear3', 'a value');

        var all = jls.util.Cookie.all();

        jls.jsunit.Assert.assertFalse('testClear1' in all);
        jls.jsunit.Assert.assertTrue('testClear2' in all);
        jls.jsunit.Assert.assertTrue('testClear3' in all);
    },
    testClear : function() {
        var name = 'testClear';
        var value = 'Hello testClear !';
        
        jls.util.Cookie.set(name, value);
        var result = jls.util.Cookie.get(name);
        jls.jsunit.Assert.assertEquals(result, value);

        jls.util.Cookie.clear(name);
        var result = jls.util.Cookie.get(name);
        jls.jsunit.Assert.assertNull(result);
    }
});

