﻿jls.loader.provide('jls.util.StringCodecTest');

jls.loader.require('jls.jsunit.TestCase');
jls.loader.require('jls.util.StringCodec');

jls.util.StringCodecTest = jls.lang.Class.create(jls.jsunit.TestCase,
{
    testBase64Encode : function() {
        var test = function(bytes, expected, buffer) {
            buffer.clear();
            for (var i = 0; i < bytes.length; i++) {
                buffer.putByte(bytes[i]);
            }
            buffer.flip();
            jls.logger.logBuffer(jls.lang.Logger.DEBUG, buffer, 'test(' + expected + ')');
            jls.jsunit.Assert.assertEquals(expected, jls.util.StringCodec.base64Encode(buffer));
        };
        var buffer = jls.lang.ByteBuffer.allocate(10);
        test([0x4d, 0x61, 0x6e], 'TWFu', buffer);
        test([0x73, 0x75, 0x72, 0x65, 0x2e], 'c3VyZS4=', buffer);
    },
    testBase64Codec : function() {
        var test = function(b64, buffer) {
            buffer.clear();
            jls.util.StringCodec.base64Decode(b64, buffer);
            buffer.flip();
            jls.logger.logBuffer(jls.lang.Logger.DEBUG, buffer, 'buffer (' + b64 + ')');
            jls.jsunit.Assert.assertEquals(b64, jls.util.StringCodec.base64Encode(buffer));
        };
        var buffer = jls.lang.ByteBuffer.allocate(10);
        test('TWFu', buffer);
        test('c3VyZS4=', buffer);
    },
    testHexCodec : function() {
        var buffer = jls.lang.ByteBuffer.allocate(10);
        var test = function(hex, buffer) {
            buffer.clear();
            jls.util.StringCodec.hexDecode(hex, buffer);
            buffer.flip();
            jls.logger.logBuffer(jls.lang.Logger.DEBUG, buffer, 'buffer');
            jls.jsunit.Assert.assertEquals(hex, jls.util.StringCodec.hexEncode(buffer));
        };
        test('011037ec', buffer);
        test('01cafe01bebe', buffer);
    }
});

