jls.loader.provide('jls.io.BufferChannelTest');

jls.loader.require('jls.jsunit.TestCase');
jls.loader.require('jls.io.BufferChannel');

jls.io.BufferChannelTest = jls.lang.Class.create(jls.jsunit.TestCase,
{
    testRead : function() {
        var text = 'Hello world !';
        var bcBuffer = jls.lang.ByteBuffer.allocate(text.length);
        bcBuffer.putString(text);
        bcBuffer.flip();
        jls.logger.logBuffer(jls.lang.Logger.INFO, bcBuffer, 'bcBuffer');
        var bc = new jls.io.BufferChannel(bcBuffer);
        var buffer = jls.lang.ByteBuffer.allocate(1024)
        bc.read(buffer);
        buffer.flip();
        jls.logger.logBuffer(jls.lang.Logger.INFO, buffer, 'buffer');
        var result = buffer.getString();
        jls.logger.debug('->' + result + '<-');
        jls.jsunit.Assert.assertEquals(text, result);
    },
    testWrite : function() {
        var text = 'Hello world !';
        var buffer = jls.lang.ByteBuffer.allocate(text.length);
        buffer.putString(text);
        buffer.flip();
        var bc = new jls.io.BufferChannel(jls.lang.ByteBuffer.allocate(1024));
        bc.write(buffer);
        var result = bc.toString();
        jls.logger.debug('->' + result + '<-');
        jls.jsunit.Assert.assertEquals(text, result);
    }
});

