jls.loader.provide('jls.io.FileTest');

jls.loader.require('jls.jsunit.TestCase');
jls.loader.require('jls.io.File');

jls.io.FileTest = jls.lang.Class.create(jls.jsunit.TestCase,
{
    setUp : function() {
        this._jlsProgname = jls.lang.System.getProperty('jls.programname');
        var windows = jls.lang.System.getProperty('file.separator') == '\\';
        if (windows) {
            this._jlsProgname += '.exe';
        }
        this._jlsHome = jls.lang.System.getProperty('jls.home');
    },
    testDir : function() {
        var jlsHomeFile = new jls.io.File(this._jlsHome);
        jls.jsunit.Assert.assertNotNull(jlsHomeFile);
        jls.jsunit.Assert.assertTrue(jlsHomeFile.exists());
        jls.jsunit.Assert.assertTrue(jlsHomeFile.isDirectory());
        jls.jsunit.Assert.assertFalse(jlsHomeFile.isFile());
    },
    testFile : function() {
        var jlsHomeFile = new jls.io.File(this._jlsHome);
        var list = jlsHomeFile.list();
        var jlsProgFile = null;
        for (var i = 0; i < list.length; i++) {
            if (list[i] == this._jlsProgname) {
                jlsProgFile = new jls.io.File(jlsHomeFile, list[i]);
                break;
            }
        }
        jls.jsunit.Assert.assertNotNull(jlsProgFile);
        jls.jsunit.Assert.assertTrue(jlsProgFile.exists());
        jls.jsunit.Assert.assertFalse(jlsProgFile.isDirectory());
        jls.jsunit.Assert.assertTrue(jlsProgFile.isFile());
    },
    testListRoots : function() {
        var userDirStr = jls.lang.System.getProperty('user.dir');
        var userDir = new jls.io.File(userDirStr);
        var userDirPath = userDir.getPath();
        jls.jsunit.Assert.assertTrue(userDir.isAbsolute());
        var roots = jls.io.File.listRoots();
        var matchCount = 0;
        for (var i = 0; i < roots.length; i++) {
            //jls.lang.System.out.println(roots[i].getPath());
            if (userDirPath.startsWith(roots[i].getPath())) {
                matchCount++;
            }
        }
        jls.jsunit.Assert.assertEquals(1, matchCount);
    }
});

