﻿jls.loader.provide('jls.io.cs.CharsetTest');

jls.loader.require('jls.jsunit.TestCase');
jls.loader.require('jls.io.cs.Charset');

jls.io.cs.CharsetTest = jls.lang.Class.create(jls.jsunit.TestCase,
{
    testASCIICodec : function() {
    	jls.io.cs.CharsetTest.testCodec('ASCII', 'Hello world !');
    	jls.io.cs.CharsetTest.testCodec('ASCII', 'Déjà !', 'D?j? !');
    	jls.io.cs.CharsetTest.testCodec('ASCII', 'The yuan symbol is Ұ.', 'The yuan symbol is ?.');
    }
});

Object.extend(jls.io.cs.CharsetTest,
{
    testCodec : function(name, text, expected) {
        jls.logger.info('testCodec(' + name + ', ' + text + ', ' + expected + ')');
    	var cs = jls.io.cs.Charset.forName(name);
    	var encoder = cs.newEncoder();
        var cb = jls.lang.CharBuffer.wrap(text);
        jls.logger.info('text.length: ' + text.length);
        jls.logger.info('cb.remaining(): ' + cb.remaining());
        var bb = jls.lang.ByteBuffer.allocate(1024);
        encoder.encode(cb, bb);
        bb.flip();
        jls.logger.logBuffer(jls.lang.Logger.INFO, bb, 'bb');
    	var decoder = cs.newDecoder();
        var cb = decoder.decode(bb);
    	cb.flip();
        var result = cb.getString();
        jls.jsunit.Assert.assertEquals(expected ? expected : text, result);
    }
});
