jls.loader.provide('jls.jsunit.TestCaseTest');

jls.loader.require('jls.jsunit.TestCase');
jls.loader.require('jls.jsunit.TestResult');

jls.jsunit.TestCaseTest = jls.lang.Class.create(jls.jsunit.TestCase,
{
    check : function(testCaseDef, runCount, failureCount, errorCount) {
        runCount = runCount || 1;
        failureCount = failureCount || 0;
        errorCount = errorCount || 0;
        var tcc = jls.lang.Class.create(jls.jsunit.TestCase, testCaseDef);
        var tc = new tcc();
        var tr = new jls.jsunit.TestResult();
        tr.run(tc);
        //tr.print();
        jls.jsunit.Assert.assertEquals(runCount, tr.runCount(), 'Invalid run count');
        jls.jsunit.Assert.assertEquals(failureCount, tr.failureCount(), 'Invalid failure count');
        jls.jsunit.Assert.assertEquals(errorCount, tr.errorCount(), 'Invalid error count');
        return {
            testCase: tc,
            testResult: tr
        };
    },
    testOk : function() {
        this.check({
            runTest : function() {
                jls.jsunit.Assert.assertTrue(true);
            }
        });
    },
    testError : function() {
        this.check({
            runTest : function() {
                throw new jls.lang.Exception('An error');
            }
        }, 1, 0, 1);
    },
    testSyntaxError : function() {
        this.check({
            runTest : function() {
                toto.titi = 2;
            }
        }, 1, 0, 1);
    },
    testFailure : function() {
        this.check({
            runTest : function() {
                jls.jsunit.Assert.assertEquals(1, 2, 'A failure');
            }
        }, 1, 1, 0);
    },
    testTestRun : function() {
        var cr = this.check({
            initialize : function($super, name) {
                $super(name);
                this._flag = 0;
            },
            runTest : function() {
                this._flag++;
            }
        });
        jls.jsunit.Assert.assertEquals(1, cr.testCase._flag, 'Test run missing');
    },
    testSetUp : function() {
        var cr = this.check({
            initialize : function($super, name) {
                $super(name);
                this._flag = 0;
            },
            setUp : function() {
                this._flag++;
            },
            runTest : function() {}
        });
        jls.jsunit.Assert.assertEquals(1, cr.testCase._flag, 'Set up missing');
    },
    testTearDown : function() {
        var cr = this.check({
            initialize : function($super, name) {
                $super(name);
                this._flag = 0;
            },
            tearDown : function() {
                this._flag++;
            },
            runTest : function() {}
        });
        jls.jsunit.Assert.assertEquals(1, cr.testCase._flag, 'Tear down missing');
    }
});

