jls.loader.provide('jls.lang.ProcessTest');

jls.loader.require('jls.jsunit.TestCase');
jls.loader.require('jls.lang.Process');
jls.loader.require('jls.lang.ProcessBuilder');

jls.lang.ProcessTest = jls.lang.Class.create(jls.jsunit.TestCase,
{
    testProcess : function() {
        var jlsLibraryPath = jls.lang.System.getProperty('jls.library.path');
        //jls.lang.System.out.println('jlsLibraryPath: "' + jlsLibraryPath + '"');
        var jlsScriptPath = jls.lang.System.getProperty('jls.script.path');
        //jls.lang.System.out.println('jlsScriptPath: "' + jlsScriptPath + '"');
        var jlsProg = jls.lang.System.getProperty('jls.home') + jls.lang.System.getProperty('file.separator') + jls.lang.System.getProperty('jls.programname');
        //jls.lang.System.out.println('jlsProg: "' + jlsProg + '"');
        var args = [jlsProg];
        if (jlsScriptPath.length > 0) {
            args.push('-sp');
            args.push(jlsScriptPath);
        }
        if (jlsLibraryPath.length > 0) {
            args.push('-lp');
            args.push(jlsLibraryPath);
        }
        args.push('jls.lang.ProcessTest');
        args.push('123');
        var process = new jls.lang.Process(args);
        var exitCode = process.waitFor();
        jls.jsunit.Assert.assertEquals(123, exitCode);
    }
});

Object.extend(jls.lang.ProcessTest,
{
    main : function(args) {
        //jls.lang.System.out.println('Hello world !');
        if (args.length != 1) {
            jls.lang.Runtime.exit(22);
        }
        jls.lang.Runtime.exit(args[0]);
    }
});

