jls.loader.provide('jls.lang.ThreadTest');

jls.loader.require('jls.jsunit.TestCase');
jls.loader.require('jls.lang.Thread');
jls.loader.require('jls.lang.Monitor');
jls.loader.require('jls.lang.Lock');

jls.lang.ThreadTest = jls.lang.Class.create(jls.jsunit.TestCase,
{
    testSleep : function() {
        var sleepDuration = 200;
        var sleepPrecision = 20;
        var startTime = jls.lang.System.currentTimeMillis();
        jls.lang.Thread.sleep(sleepDuration);
        var endTime = jls.lang.System.currentTimeMillis();
        jls.jsunit.Assert.assertEquals(Math.round(sleepDuration / sleepPrecision), Math.round((endTime - startTime) / sleepPrecision));
    },
    /*testDaemon : function() {
    },
    testShared : function() {
    },*/
    testJoin : function() {
        var aThread = new jls.lang.Thread();
        aThread._test_count = 0;
        aThread.run = function() {
            //jls.lang.System.out.println('testJoin(): thread started');
            //jls.lang.Thread.sleep(100);
            this._test_count++;
            //jls.lang.System.out.println('testJoin(): thread ending');
        };
        jls.jsunit.Assert.assertEquals(0, aThread._test_count);
        aThread.start(aThread);
        //jls.lang.Thread.sleep(200);
        aThread.join();
        jls.jsunit.Assert.assertEquals(1, aThread._test_count);
    },
    testMonitor : function() {
        var thread1 = new jls.lang.Thread();
        var thread2 = new jls.lang.Thread();
        var monitor = new jls.lang.Monitor();
        monitor._test_count = 0;
        thread1.run = function() {
            monitor.wait();
            monitor._test_count = monitor._test_count * 2;
        };
        thread2.run = function() {
            //jls.lang.Thread.sleep(100);
            monitor._test_count++;
            monitor.notify();
        };
        jls.jsunit.Assert.assertEquals(0, monitor._test_count);
        thread1.start();
        //jls.lang.Thread.sleep(100);
        thread2.start();
        //jls.lang.Thread.sleep(200);
        thread1.join();
        thread2.join();
        jls.jsunit.Assert.assertEquals(2, monitor._test_count);
    },
    testLock : function() {
        var thread1 = new jls.lang.Thread();
        var thread2 = new jls.lang.Thread();
        var lock = new jls.lang.Lock();
        lock._test_count = 0;
        var run = function() {
            for (var i = 0; i < 5; i++) {
                lock.lock();
                var cc = lock._test_count;
                //jls.lang.Thread.sleep(100);
                lock._test_count = cc + 1;
                lock.unlock();
            }
        }
        thread1.run = run;
        thread2.run = run;
        jls.jsunit.Assert.assertEquals(0, lock._test_count);
        thread1.start();
        thread2.start();
        //jls.lang.Thread.sleep(200);
        thread1.join();
        thread2.join();
        jls.jsunit.Assert.assertEquals(10, lock._test_count);
    }
});

