jls.loader.provide('jls.net.BufferSelectionHandlerTest');

jls.loader.require('jls.jsunit.TestCase');
jls.loader.require('jls.net.BufferSelectionHandler');
jls.loader.require('jls.io.BufferChannel');

jls.net.BufferSelectionHandlerTest = jls.lang.Class.create(jls.jsunit.TestCase,
{
    testRead : function() {
        var text = 'Hello world !';
        var bc = new jls.io.BufferChannel(jls.lang.ByteBuffer.fromString(text));
        var buffer = jls.lang.ByteBuffer.allocate(1024);
        var sh = new jls.net.BufferSelectionHandler(buffer);
        sh.onRead(bc);
        sh.buffer().flip();
        var result = sh.buffer().getString();
        //jls.lang.System.out.println('->' + result + '<-');
        jls.jsunit.Assert.assertEquals(text, result);
    },
    testWrite : function() {
        var text = 'Hello world !';
        var sh = new jls.net.BufferSelectionHandler(jls.lang.ByteBuffer.fromString(text));
        var bc = new jls.io.BufferChannel(jls.lang.ByteBuffer.allocate(1024));
        sh.onWrite(bc);
        var result = bc.toString();
        //jls.lang.System.out.println('->' + result + '<-');
        jls.jsunit.Assert.assertEquals(text, result);
    }
});

