jls.loader.provide('jls.net.InetAddressTest');

jls.loader.require('jls.jsunit.TestCase');
jls.loader.require('jls.net.InetAddress');

jls.net.InetAddressTest = jls.lang.Class.create(jls.jsunit.TestCase,
{
    testGetAllByName : function() {
        var hostname = _native.core.properties['os.hostname'];
        var inetAddresses = jls.net.InetAddress.getAllByName(hostname);
        jls.jsunit.Assert.assertTrue(inetAddresses[0].getHostName().startsWith(hostname));
    },
    testGetByName : function() {
        var inetAddress = jls.net.InetAddress.getByName('localhost');
        jls.jsunit.Assert.assertEquals('127.0.0.1', inetAddress.getHostAddress());
    },
    testGetByAddress : function() {
        var inetAddress = jls.net.InetAddress.getByAddress('127.0.0.1');
        jls.jsunit.Assert.assertEquals('127.0.0.1', inetAddress.getHostAddress());
    }
});

