jls.loader.provide('jls.net.SelectionHandlerSequenceTest');

jls.loader.require('jls.jsunit.TestCase');
jls.loader.require('jls.io.BufferChannel');
jls.loader.require('jls.net.BufferSelectionHandler');
jls.loader.require('jls.net.SelectionHandlerSequence');

jls.net.SelectionHandlerSequenceTest = jls.lang.Class.create(jls.jsunit.TestCase,
{
    testReadSingle : function() {
        var text = 'Hello world !';
        var bc = new jls.io.BufferChannel(jls.lang.ByteBuffer.fromString(text));
        var shs = new jls.net.SelectionHandlerSequence(new jls.net.BufferSelectionHandler(jls.lang.ByteBuffer.allocate(1024)));
        shs.onRead(bc);
        shs.getSelectionHandler(0).buffer().flip();
        var result = shs.getSelectionHandler(0).buffer().getString();
        //jls.lang.System.out.println('->' + result + '<-');
        jls.jsunit.Assert.assertEquals(text, result);
    },
    testRead : function() {
        var text1 = 'Hello';
        var text2 = ' world !';
        var bc = new jls.io.BufferChannel(jls.lang.ByteBuffer.fromString(text1 + text2, 'ASCII'));
        //jls.lang.System.out.println('bc.buffer().remaining(): ' + bc.buffer().remaining());
        var shs = new jls.net.SelectionHandlerSequence(new jls.net.BufferSelectionHandler(jls.lang.ByteBuffer.allocate(text1.length)),
			new jls.net.BufferSelectionHandler(jls.lang.ByteBuffer.allocate(text2.length)));
        shs.onRead(bc);
        shs.getSelectionHandler(0).buffer().flip();
        shs.getSelectionHandler(1).buffer().flip();
        var result1 = shs.getSelectionHandler(0).buffer().getString('ASCII');
        var result2 = shs.getSelectionHandler(1).buffer().getString('ASCII');
        //jls.lang.System.out.println('->' + result + '<-');
        jls.jsunit.Assert.assertEquals(text1 + text2, result1 + result2);
    },
    testWriteSingle : function() {
        var text = 'Hello world !';
        var shs = new jls.net.SelectionHandlerSequence(new jls.net.BufferSelectionHandler(jls.lang.ByteBuffer.fromString(text)));
        var bc = new jls.io.BufferChannel(jls.lang.ByteBuffer.allocate(1024));
        shs.onWrite(bc);
        var result = bc.toString();
        //jls.lang.System.out.println('->' + result + '<-');
        jls.jsunit.Assert.assertEquals(text, result);
    },
    testWrite : function() {
        var text1 = 'Hello';
        var text2 = ' world !';
        var shs = new jls.net.SelectionHandlerSequence(new jls.net.BufferSelectionHandler(jls.lang.ByteBuffer.fromString(text1)),
			new jls.net.BufferSelectionHandler(jls.lang.ByteBuffer.fromString(text2)));
        var bc = new jls.io.BufferChannel(jls.lang.ByteBuffer.allocate(1024));
        shs.onWrite(bc);
        var result = bc.toString();
        //jls.lang.System.out.println('->' + result + '<-');
        jls.jsunit.Assert.assertEquals(text1 + text2, result);
    }
});

