jls.loader.provide('jls.net.SelectorTest');

jls.loader.require('jls.jsunit.TestCase');
jls.loader.require('jls.net.PollableEvent');
jls.loader.require('jls.net.Selector');

jls.net.SelectorTest = jls.lang.Class.create(jls.jsunit.TestCase,
{
    testComplete : function() {
        var event = new jls.net.PollableEvent();
        event._test_key = 'My key';
        var selector = new jls.net.Selector();
        selector.register(event, event);
        
        var thread = new jls.lang.Thread();
        thread._test_event = event;
        thread.run = function() {
            jls.lang.Thread.sleep(500);
            jls.logger.debug('set PollableEvent');
            this._test_event.set();
            //jls.lang.Thread.sleep(500);
        }
        thread.start(thread);
        
        jls.logger.debug('select...');
        var selectedKeys = selector.select();
        thread.join();
        jls.logger.debug('wait PollableEvent');
        event.wait();
        selector.close();
        event.close();

        jls.jsunit.Assert.assertEquals(1, selectedKeys.length);
        // sk.key, sk.inFlags, sk.outFlags
        jls.jsunit.Assert.assertEquals(jls.net.Selector.OP_READ, selectedKeys[0].inFlags);
        jls.jsunit.Assert.assertEquals(jls.net.Selector.OP_READ, selectedKeys[0].outFlags);
        jls.jsunit.Assert.assertEquals('My key', selectedKeys[0].key._test_key);
    }
});

