jls.loader.provide('jls.net.SocketTest');

jls.loader.require('jls.jsunit.TestCase');
jls.loader.require('jls.net.Socket');
jls.loader.require('jls.net.ServerSocket');

jls.net.SocketTest = jls.lang.Class.create(jls.jsunit.TestCase,
{
    testComplete : function() {
        var thread = new jls.lang.Thread();
        thread._test_monitor = new jls.lang.Monitor();
        thread._test_result = null;
        thread.run = function() {
            var serverSocket = new jls.net.ServerSocket(12345/*, 5, 'localhost'*/);
            this._test_monitor.notify();
            var socket = serverSocket.accept();
            var buffer = jls.lang.ByteBuffer.allocate(256);
            socket.read(buffer);
            buffer.flip();
            this._test_result = buffer.getString('ASCII');
            
            buffer.clear();
            buffer.putString('pong', 'ASCII');
            buffer.flip();
            socket.write(buffer);
            socket.close();
        }
        thread.start(thread);
        thread._test_monitor.wait();
        
        var socket = new jls.net.Socket('localhost', 12345);
        var buffer = jls.lang.ByteBuffer.allocate(256);
        buffer.putString('ping', 'ASCII');
        buffer.flip();
        socket.write(buffer);
        buffer.clear();
        socket.read(buffer);
        socket.close();
        
        buffer.flip();
        jls.jsunit.Assert.assertEquals('pong', buffer.getString('ASCII'));
        
        thread.join();
        jls.jsunit.Assert.assertEquals('ping', thread._test_result);
    }
});

