jls.loader.provide('jls.net.URLTest');

jls.loader.require('jls.jsunit.TestCase');
jls.loader.require('jls.net.URL');

jls.net.URLTest = jls.lang.Class.create(jls.jsunit.TestCase,
{
    testGetProtocol : function() {
        var url = new jls.net.URL('http://www.kilo.com/fr');
        jls.jsunit.Assert.assertEquals('http', url.getProtocol());
    },
    testGetHost : function() {
        var url = new jls.net.URL('http://www.kilo.com/fr');
        jls.jsunit.Assert.assertEquals('www.kilo.com', url.getHost());
    },
    testGetDefaultPort : function() {
        var url = new jls.net.URL('http://www.kilo.com/');
        jls.jsunit.Assert.assertEquals(80, url.getDefaultPort());
        url = new jls.net.URL('https://www.kilo.com/');
        jls.jsunit.Assert.assertEquals(443, url.getDefaultPort());
        url = new jls.net.URL('unknown://www.kilo.com/');
        jls.jsunit.Assert.assertEquals(-1, url.getDefaultPort());
    },
    testGetPort : function() {
        var url = new jls.net.URL('http://www.kilo.com:8080/');
        jls.jsunit.Assert.assertEquals(8080, url.getPort());
        url = new jls.net.URL('http://www.kilo.com/');
        jls.jsunit.Assert.assertEquals(-1, url.getPort());
    },
    testGetFile : function() {
        var url = new jls.net.URL('http://www.kilo.com/fr');
        jls.jsunit.Assert.assertEquals('/fr', url.getFile());
        url = new jls.net.URL('http://www.kilo.com/');
        jls.jsunit.Assert.assertEquals('/', url.getFile());
        url = new jls.net.URL('http://www.kilo.com');
        jls.jsunit.Assert.assertEquals('/', url.getFile());
        url = new jls.net.URL('http://www.kilo.com/fr?id=2');
        jls.jsunit.Assert.assertEquals('/fr?id=2', url.getFile());
        url = new jls.net.URL('http://www.kilo.com/fr#here');
        jls.jsunit.Assert.assertEquals('/fr#here', url.getFile());
    },
    testGetPath : function() {
        var url = new jls.net.URL('http://www.kilo.com/fr?id=2');
        jls.jsunit.Assert.assertEquals('/fr', url.getPath());
        url = new jls.net.URL('http://www.kilo.com/');
        jls.jsunit.Assert.assertEquals('/', url.getPath());
        url = new jls.net.URL('http://www.kilo.com/fr#here');
        jls.jsunit.Assert.assertEquals('/fr', url.getPath());
    },
    testGetQuery : function() {
        var url = new jls.net.URL('http://www.kilo.com/fr?id=2');
        jls.jsunit.Assert.assertEquals('id=2', url.getQuery());
        url = new jls.net.URL('http://www.kilo.com/');
        jls.jsunit.Assert.assertNull(url.getQuery());
        url = new jls.net.URL('http://www.kilo.com/fr#here');
        jls.jsunit.Assert.assertNull(url.getQuery());
    },
    testGetRef : function() {
        var url = new jls.net.URL('http://www.kilo.com/fr#here');
        jls.jsunit.Assert.assertEquals('here', url.getRef());
        url = new jls.net.URL('http://www.kilo.com/');
        jls.jsunit.Assert.assertNull(url.getRef());
        url = new jls.net.URL('http://www.kilo.com/fr?id=2');
        jls.jsunit.Assert.assertNull(url.getRef());
    },
    testToExternalForm : function() {
        var url = new jls.net.URL('http://www.kilo.com/fr#here');
        jls.jsunit.Assert.assertEquals('http://www.kilo.com/fr#here', url.toExternalForm());
        url = new jls.net.URL('http://www.kilo.com/');
        jls.jsunit.Assert.assertEquals('http://www.kilo.com/', url.toExternalForm());
        url = new jls.net.URL('http://www.kilo.com/fr?id=2');
        jls.jsunit.Assert.assertEquals('http://www.kilo.com/fr?id=2', url.toExternalForm());
    }
});

