jls.loader.require('jls.net.http.ServerMgr');
jls.loader.require('jls.io.File');

var jlsHome = new jls.io.File(jls.lang.System.getProperty('jls.home'));
var wbDir = new jls.io.File(jlsHome, 'wb');

var address = 'http://localhost:8080/';

var createFileSystemContext = function(address, file) {
	if (! file.exists()) {
		new jls.lang.Exception('Cannot find file ' + file.getPath());
	}
    var ctx = jls.net.http.ServerMgr.getInstance().createContext(address);
    ctx.setHandler(file.isDirectory() ? jls.net.http.HttpServer.fileHandler : jls.net.http.HttpServer.zipHandler);
    ctx.setAttribute('rootFile', file);
    ctx.setAttribute('contentTypes', jls.net.http.HttpServer.defaultContentTypes);
    ctx.setAttribute('createFolderPage', jls.net.http.HttpServer.createFolderPage);
};

jls.lang.Runtime.addShutdownHook(function() {
    jls.lang.System.out.println('Shutdown HTTP servers');
    jls.net.http.ServerMgr.getInstance().shutdown();
});

jls.lang.System.out.println('Root dir: ' + wbDir.getPath());
createFileSystemContext(address, wbDir);
createFileSystemContext(address + 'rt', new jls.io.File(wbDir, 'rt.zip'));
createFileSystemContext(address + 'test', new jls.io.File(wbDir, 'test.zip'));
createFileSystemContext(address + 'jsdoc', new jls.io.File(wbDir, 'jsdoc.zip'));
createFileSystemContext(address + 'jsdoc-sa', new jls.io.File(jlsHome, 'jsdoc.zip'));

var ctx = jls.net.http.ServerMgr.getInstance().createContext(address + 'admin/stop');
ctx.setHandler(jls.net.http.HttpServer.shutdownHandler);

jls.lang.System.out.println('HTTP server started on ' + address);

if (jls.lang.System.getProperty('os.sysname', '') == 'Windows_NT') {
    jls.loader.require('jls.win32.Window');
	jls.win32.Window.shellExecute(address);
}
