jls.loader.require('jls.net.http.ServerMgr');
jls.loader.require('jls.net.URL');

var address = 'http://localhost:8080/';

var ctx = jls.net.http.ServerMgr.getInstance().createContext(address);
ctx.setHandler(function(httpExchange) {
    jls.logger.info('onRequest(' + httpExchange.getRequestURI() + ')');
    //httpExchange.setRequestBodySelectionHandler();
    httpExchange.sendResponseHeaders(jls.net.http.HttpHeader.HTTP_NOT_FOUND, 'Resource "' + httpExchange.getRequestURI() + '" not found.');
});

var onResponseHeader = function(httpExchange) {
    var contentLength = urlConnection.getContentLength();
    jls.logger.info('contentLength: ' + contentLength);
    var sh = new jls.net.BufferSelectionHandler(jls.lang.ByteBuffer.allocate(contentLength));
    urlConnection.setResponseBodySelectionHandler(sh);
};

var url = new jls.net.URL(address + 'something');
var urlConnection = url.openConnection();
urlConnection.connect();
urlConnection.onResponseHeader = onResponseHeader;
urlConnection.send();
urlConnection.disconnect();

jls.net.http.ServerMgr.getInstance().shutdown();

var buffer = urlConnection.getResponseBodySelectionHandler().buffer();
jls.logger.info('buffer: ' + buffer.capacity() + ', ' + buffer.remaining());
var response = buffer.flip().getString('UTF-8');
jls.lang.System.out.println('->' + response + '<-');

