jls.loader.require('jls.net.http.ServerMgr');

jls.lang.Runtime.addShutdownHook(function() {
    jls.lang.System.out.println('Shutdown HTTP servers');
    jls.net.http.ServerMgr.getInstance().shutdown();
});

var rootFile = new jls.io.File('.');
if (jls.lang.System.getArguments().length > 0) {
    rootFile = new jls.io.File(jls.lang.System.getArguments()[0]);
}

var address = 'http://localhost:8080/';

var ctx = jls.net.http.ServerMgr.getInstance().createContext(address);
ctx.setHandler(jls.net.http.HttpServer.fileHandler);
ctx.setAttribute('rootFile', rootFile);
ctx.setAttribute('contentTypes', jls.net.http.HttpServer.defaultContentTypes);
ctx.setAttribute('createFolderPage', jls.net.http.HttpServer.createFolderPage);

ctx = jls.net.http.ServerMgr.getInstance().createContext(address + 'admin/stop');
ctx.setHandler(jls.net.http.HttpServer.shutdownHandler);

jls.lang.System.out.println('HTTP server started on ' + address);

if (jls.lang.System.getProperty('os.sysname', '') == 'Windows_NT') {
    jls.loader.require('jls.win32.Window');
	jls.win32.Window.shellExecute(address);
}
