jls.loader.require('jls.util.Image');

var die = function(exitCode, message) {
	if (message) {
		jls.lang.System.err.println(message);
	}
    jls.lang.System.exit(typeof exitCode == 'number' ? exitCode : 1);
};
var usage = function() {
    die(22, 'Usage: jpegresize.js -i <filename> -w <maxWidth> [-o <filename>] [-y] [-h <maxHeight>] [-s <sharpFactor>].');
};
var computeArgumentMap = function() {
	var args = jls.lang.System.getArguments();
	var argMap = {};
	var key = '';
	for (var i = 0; i < args.length; i++) {
		var arg = args[i];
		jls.logger.trace('arg: "' + arg + '"');
		if (arg.startsWith('-')) {
			key = arg.substring(1);
			if (! (key in argMap)) {
				argMap[key] = true;
			}
		} else {
			if (argMap[key] === true) {
				argMap[key] = arg;
			} else {
				argMap[key] += ' ' + arg;
			}
		}
	}
	return argMap;
};
var getProperty = function(object, key, defaultValue) {
    return key in object ? object[key] : defaultValue;
};

var argMap = computeArgumentMap();

jls.logger.logObject(jls.lang.Logger.DEBUG, 'argMap', argMap);

var inFilename = getProperty(argMap, 'i', null);
var outFilename = getProperty(argMap, 'o', null);
var maxWidth = parseInt(getProperty(argMap, 'w', '0'), 10);
var maxHeight = parseInt(getProperty(argMap, 'h', '0'), 10);
var sharpFactor = parseFloat(getProperty(argMap, 's', '0'));
var overwrite = 'y' in argMap;

if ((inFilename == null) || (maxWidth <= 0) || (maxHeight < 0) || (sharpFactor < 0) || (sharpFactor > 10)) {
	usage();
}
if (outFilename == null) {
	outFilename = inFilename + '.resized.jpg';
}
if (maxHeight == 0) {
	maxHeight = maxWidth;
}
var imgFile = new jls.io.File(inFilename);
if (! imgFile.exists()) {
    die(1, 'The filename "' + inFilename + '" does not exist.');
}
jls.lang.System.out.println('reading ' + inFilename);
var fc = new jls.io.FileInputStream(imgFile);
var img = jls.util.Image.readJPEG(fc, jls.util.Image.COLOR_SPACE_YCbCr, 1.0, function (width, height) {
	var denom = Math.floor(Math.min(width / maxWidth, height / maxHeight));
	if (denom <= 1) {
		return null;
	}
	if (denom > 8) {
		denom = 8;
	}
	return [1, denom];
});
fc.close();

var width, height = Math.floor(maxWidth * img.getHeight() / img.getWidth());
if (height <= maxHeight) {
	width = maxWidth;
} else {
	width = Math.floor(maxHeight * img.getWidth() / img.getHeight());
	height = maxHeight;
}
jls.lang.System.out.println('resize to ' + width + ' x ' + height);
img = img.subsample(width, height);

if (sharpFactor > 0) {
	jls.lang.System.out.println('sharp factor is ' + sharpFactor);
	var kernel = [
	              -sharpFactor * 0.707, -sharpFactor, -sharpFactor * 0.707,
	              -sharpFactor, 1 + sharpFactor * 6.828, -sharpFactor,
	              -sharpFactor * 0.707, -sharpFactor, -sharpFactor * 0.707
	              ];
	// apply convolution on the luma component
	img.convolve(kernel, 0, 0);
}

imgFile = new jls.io.File(outFilename);
if ((! overwrite) && imgFile.exists()) {
    die(1, 'The filename "' + outFilename + '" already exists.');
}
jls.lang.System.out.println('writing ' + outFilename);
fc = new jls.io.FileOutputStream(imgFile);
jls.util.Image.writeJPEG(img, fc, 90);
fc.close();

