
_native.core.loadLibrary('jls_io');

var printLine = function(line) {
    _native.io.stdout.writeString(line ? line + '\n' : '\n');
}

var indent = '  ';

var printLibraryClass = function(lib, name) {
    printLine(indent + indent + 'class ' + name);
    var clazz = lib[name];
    for (var k in clazz) {
        var type = typeof (clazz[k]);
        if (type == 'function') {
            continue;
        }
        printLine(indent + indent + indent + 'static ' + type + ' ' + k + ' (' + clazz[k] + ')');
    }
    clazz = lib[name].prototype;
    for (var k in clazz) {
        var type = typeof (clazz[k]);
        if (type == 'function') {
            printLine(indent + indent + indent + type + ' ' + k + '() ');
        } else {
            printLine(indent + indent + indent + type + ' ' + k + ' (' + clazz[k] + ')');
        }
    }
}
var printLibrary = function(name) {
    printLine(indent + name);
    var lib = _native[name];
    for (var k in lib) {
        var type = typeof (lib[k]);
        if (type == 'function') {
            if (lib[k].prototype.toString().indexOf('Object') > 0) {
                printLine(indent + indent + type + ' ' + k + '()');
            } else {
                printLibraryClass(lib, k);
            }
        } else {
            printLine(indent + indent + type + ' ' + k + ' (' + lib[k] + ')');
        }
    }
}

// Found all library paths
var jlsHome = _native.core.properties['jls.home'];
var fileSeparator = _native.core.properties['file.separator'];
var pathSeparator = _native.core.properties['path.separator'];
var libPaths = [jlsHome + fileSeparator + 'ext'];
libPaths = libPaths.concat(_native.core.properties['jls.library.path'].split(pathSeparator));
for (var i = libPaths.length - 1; i >= 0; i--) {
    if (_native.io.getType(libPaths[i]) != _native.io.TYPE_DIRECTORY) {
        libPaths.splice(i, 1);
    }
}

// Found all available libraries
var filenames = [];
for (var i = 0; i < libPaths.length; i++) {
    filenames = filenames.concat(_native.io.list(libPaths[i]));
}
var libs = [];
for (var i = 0; i < filenames.length; i++) {
    var index = filenames[i].lastIndexOf('.');
    if (index > 0) {
        var name = filenames[i].substring(0, index);
	if (name.startsWith('lib')) {
		name = name.substr(3);
	}
        var ext = filenames[i].substr(index);
        if (((ext != '.dll') && (ext != '.so')) || (name == 'jls_io') || (name == 'jls') || (name == 'js') || (name == 'nspr')) {
            continue;
        }
        libs.push(name);
    }
}
// Load libraries
for (var i = 0; i < libs.length; i++) {
    try {
        _native.core.loadLibrary(libs[i]);
    }
    catch (e) {
        printLine('Cannot load library "' + libs[i] + '" (' + e + ')');
    }
}

// Display Native Libraries
printLine('Native Libraries:');
for (var name in _native) {
    printLibrary(name);
}

