jls.loader.require('jls.lang.System');
jls.loader.require('jls.lang.Thread');
jls.loader.require('jls.net.Socket');
jls.loader.require('jls.net.ServerSocket');
jls.loader.require('jls.net.SelectorThread');

jls.loader.require('jls.io.File');
jls.loader.require('jls.io.FileChannel');
jls.loader.require('jls.io.FileOutputStream');

var dumpBuffer = function(buffer) {
    var buffer = buffer.slice();
    var w = 16;
    var hex = '0123456789abcdef';
    for (var l = 0; buffer.remaining() > 0; l += w) {
        var lineHex = '';
        var lineAsc = '';
        for (var c = 0; buffer.remaining() > 0 && c < w; c++) {
            var b = buffer.getByte();
            lineHex += hex.charAt(b >> 4) + hex.charAt(b & 0x0f) + ' ';
            lineAsc += b > 31 && b < 128 ? String.fromCharCode(b) : ' ';
        }
        jls.lang.System.out.println(lineHex + lineAsc);
    }
};

var serverPort = 8080;
var proxyHost = 'proxy';
var proxyPort = 8080;
proxyHost = 'localhost';
proxyPort = 8888;

jls.lang.System.out.println('Start server on ' + serverPort + ' redirecting to ' + proxyHost + ' on ' + proxyPort);
var serverSocket = new jls.net.ServerSocket(serverPort);
serverSocket.configureBlocking(false);

var selectorThread = new jls.net.SelectorThread();
selectorThread.register(serverSocket, function(key) {
    jls.lang.System.out.println('Accept connection');
    
    var socket = key.socket.accept();
    socket.configureBlocking(false);
    
    var ctx = {};
    ctx.inBuffer = jls.lang.ByteBuffer.allocate(1024);
    ctx.outBuffer = jls.lang.ByteBuffer.allocate(1024);
    
    var psocket = new jls.net.Socket(proxyHost, proxyPort);
    psocket.configureBlocking(false);
    
    var delay = 0;
    
    ctx.inKey = key.selectorThread.register(socket, function(key, inFlags, outFlags) {
        if (inFlags == jls.net.Selector.OP_READ) {
            ctx.inBuffer.clear();
            key.socket.read(ctx.inBuffer);
            ctx.inBuffer.flip();
            
            if (ctx.inBuffer.remaining() > 0) {
                jls.lang.System.out.println('IN RECV ' + ctx.inBuffer.remaining() + ' bytes');
                dumpBuffer(ctx.inBuffer);
                key.selectorThread.changeMode(ctx.outKey, jls.net.Selector.OP_WRITE);
            } else {
                jls.lang.System.out.println('IN CLOSED');
                ctx.inKey = null;
                key.selectorThread.lazyunregister(key);
                key.socket.close();
            }
        }
        if (inFlags == jls.net.Selector.OP_WRITE) {
            if (ctx.outBuffer.remaining() > 0) {
                key.socket.write(ctx.outBuffer);
            } else {
                jls.lang.System.out.println('IN SEND flushed');
                key.selectorThread.changeMode(ctx.inKey, jls.net.Selector.OP_READ);
            }
        }
        if (delay > 0) {
            jls.lang.Thread.sleep(delay * 1000);
        }
    }, jls.net.Selector.OP_READ);
    
    ctx.outKey = key.selectorThread.register(psocket, function(key, inFlags, outFlags) {
        if (inFlags == jls.net.Selector.OP_READ) {
            ctx.outBuffer.clear();
            key.socket.read(ctx.outBuffer);
            ctx.outBuffer.flip();
            
            if (ctx.outBuffer.remaining() > 0) {
                jls.lang.System.out.println('OUT RECV ' + ctx.outBuffer.remaining() + ' bytes');
                dumpBuffer(ctx.outBuffer);
                key.selectorThread.changeMode(ctx.inKey, jls.net.Selector.OP_WRITE);
            } else {
                jls.lang.System.out.println('OUT CLOSED');
                ctx.outKey = null;
                key.selectorThread.lazyunregister(key);
                key.socket.close();
            }
        }
        if (inFlags == jls.net.Selector.OP_WRITE) {
            if (ctx.inBuffer.remaining() > 0) {
                key.socket.write(ctx.inBuffer);
            } else {
                jls.lang.System.out.println('OUT SEND flushed');
                key.selectorThread.changeMode(ctx.outKey, jls.net.Selector.OP_READ);
            }
        }
        if (delay > 0) {
            jls.lang.Thread.sleep(delay * 1000);
        }
    }, jls.net.Selector.OP_READ);
    
}, jls.net.Selector.OP_ACCEPT);

selectorThread.start();

jls.lang.Runtime.addShutdownHook(function() {
    jls.lang.System.out.println('Shutdown proxy');
    selectorThread.stop();
});

