jls.loader.require('jls.gui.Frame');
jls.loader.require('jls.gui.Panel');
jls.loader.require('jls.gui.Button');
jls.loader.require('jls.gui.TextArea');
jls.loader.require('jls.gui.MenuItem');
jls.loader.require('jls.gui.CommonDialog');
jls.loader.require('jls.io.File');
jls.loader.require('jls.io.FileInputStream');
jls.loader.require('jls.io.InputStreamReader');
jls.loader.require('jls.io.FileOutputStream');
jls.loader.require('jls.io.OutputStreamWriter');

var icon = 'res/run.ico';
if (! new jls.io.File(icon).exists()) {
    icon = 'D:/bin/jls/icons/run.ico';
}
// Create windows
var separator = jls.lang.System.getProperty('line.separator', '\n');
var frame = new jls.gui.Frame({attributes: {title: 'SandBox', icon: icon, layout: 'jls.gui.BorderLayout'}, style: {splitSize: 5, width: 640, height: 480}});
var welcomeText = "// Put some code here" + separator + "jls.lang.System.out.println('Hello world !');";
var topPanel = new jls.gui.Panel({style: {height: 30, region: 'top', textAlign: 'left', verticalAlign: 'middle', verticalPosition: 'middle', hGap: 3, vGap: 3}}, frame);
var evalButton = new jls.gui.Button({attributes: {text: 'Evaluate'}, style: {width: 80, height: 20}}, topPanel);
var logTextArea = new jls.gui.TextArea({style: {fontFamily: 'Courier New', fontSize: 16, height: 120, region: 'bottom', splitter: 'true', overflow: 'scroll'}}, frame);
var scriptTextArea = new jls.gui.TextArea({attributes: {text: welcomeText}, style: {fontFamily: 'Courier New', fontSize: 16, region: 'center', border: 'true', overflow: 'scroll'}}, frame);

// Redirect standard error and output streams
var stdoutOrigin = jls.lang.System.out;
var stderrOrigin = jls.lang.System.err;
var TextAreaPrintStream = jls.lang.Class.create({
    initialize : function(textArea) {
        this._textArea = textArea;
        this._buffer = null;
    },
    flush : function() {
        if (this._buffer != null) {
            this._textArea.replaceSelection(this._buffer);
            this._buffer = null;
        }
        return this;
    },
    print : function(s) {
        if (this._buffer == null) {
            this._buffer = s;
        } else {
            this._buffer += s;
        }
        if (s.indexOf('\n') >= 0) {
            this.flush();
        }
        return s.length;
    },
    println : function(s) {
        return this.print(s + separator);
    }
});
jls.lang.System.out = new TextAreaPrintStream(logTextArea);
jls.lang.System.err = jls.lang.System.out;
jls.lang.System.out.println('// System output');

// Misc handlers
var evalFn = function(event) {
    var script = scriptTextArea.getAttribute('text');
    if ((script == null) || (script.length == 0)) {
        return;
    }
    jls.logger.debug('evaluating: ' + script);
    logTextArea.setAttribute('text', '');
    eval('(function() {' + script + '})()');
};
var notImplementedMenuFn = function(event) {
    jls.lang.System.out.println('Menu not implemented: ' + event.menuItem._label);
};
var shutdownSandBox = function() {
    jls.lang.System.out = stdoutOrigin;
    jls.lang.System.err = stderrOrigin;
    frame.onDestroy();
};

// Create menu
var menu = jls.gui.MenuItem.createMenu();
var fileMenu = new jls.gui.MenuItem({label: 'File', popup: true}, menu);
var runMenu = new jls.gui.MenuItem({label: 'Run', popup: true}, menu);
var aboutMenu = new jls.gui.MenuItem({label: '?', popup: true}, menu);
new jls.gui.MenuItem({label: 'New', event: 'new'}, fileMenu);
new jls.gui.MenuItem({label: 'Open...', event: 'open'}, fileMenu);
new jls.gui.MenuItem({label: 'Save as...', event: 'save'}, fileMenu);
jls.gui.MenuItem.createMenuSeparator(fileMenu);
new jls.gui.MenuItem({label: 'Exit', event: 'exit'}, fileMenu);
new jls.gui.MenuItem({label: 'Evaluate', event: 'eval'}, runMenu);
new jls.gui.MenuItem({label: 'Clear', event: 'clear'}, runMenu);
new jls.gui.MenuItem({label: 'About SandBox', event: 'about'}, aboutMenu);

// Register UI handlers
evalButton.observe('click', evalFn);
menu.observe('open', function(event) {
    var filename = jls.gui.CommonDialog.getOpenFileName(frame);
    if (! filename) {
        return;
    }
    jls.lang.System.out.println('Loading "' + filename + '"');
    var file = new jls.io.File(filename);
    if (! file.isFile()) {
        jls.lang.System.out.println('File not found');
        return;
    }
    if (file.length() == 0) {
        return;
    }
    var cbuffer = jls.lang.CharBuffer.allocate(file.length() + 1);
    var input = new jls.io.InputStreamReader(new jls.io.FileInputStream(file));
    input.readCharBuffer(cbuffer);
    input.close();
    var script = scriptTextArea.setAttribute('text', cbuffer.flip().getString());
});
menu.observe('new', function(event) {
    scriptTextArea.setAttribute('text', '');
});
menu.observe('clear', function(event) {
    logTextArea.setAttribute('text', '');
});
menu.observe('save', function(event) {
    var filename = jls.gui.CommonDialog.getSaveFileName(frame);
    if (! filename) {
        return;
    }
    jls.lang.System.out.println('Saving as "' + filename + '"');
    var script = scriptTextArea.getAttribute('text');
    if ((script == null) || (script.length == 0)) {
        return;
    }
    var file = new jls.io.File(filename);
    var output = new jls.io.OutputStreamWriter(new jls.io.FileOutputStream(file));
    output.write(script);
    output.close();
});
menu.observe('exit', shutdownSandBox);
menu.observe('eval', evalFn);
menu.observe('about', notImplementedMenuFn);

frame.setMenu(menu);
