jls.loader.provide('spyl.ffgui.FFmpegConsole');

jls.loader.require('jls.gui.Panel');
jls.loader.require('jls.gui.Label');
jls.loader.require('jls.gui.TextArea');
jls.loader.require('jls.gui.Button');
jls.loader.require('jls.gui.CommonDialog');

spyl.ffgui.FFmpegConsole = jls.lang.Class.create({
    initialize : function(launcher, args) {
    	this._launcher = launcher;
    	this._panel = null;
    	this._process = null;
        this._thread = null;
        this._consoleTA = null;
        this.createPane();
        this.start(args);
    },
    createPane : function() {
    	this._panel = new jls.gui.Panel({attributes: {title: 'Console', layout: 'jls.gui.BorderLayout'}, style: {splitSize: 5}}, this._launcher.getTab());
    	var bottomPanel = new jls.gui.Panel({style: {height: 30, region: 'bottom', textAlign: 'left', verticalAlign: 'middle', verticalPosition: 'middle', hGap: 3, vGap: 3}}, this._panel);
    	this._consoleTA = new jls.gui.TextArea({attributes: {readonly: true}, style: {fontFamily: 'Courier New', fontSize: 16, overflow: 'scroll', region: 'center'}}, this._panel);
        var stopButton = new jls.gui.Button({attributes: {text: 'Stop'}, style: {width: 120, height: 22}}, bottomPanel);
        stopButton.observe('click', this.onStop.bind(this));
    },
    onStop : function(event) {
    	this._process.destroy();
    },
    onDetach : function(event) {
    	this._process.detach();
    },
    start : function(args) {
        jls.lang.System.out.println('ffmpeg console arguments: ' + args.join(' '));
    	var pb = new jls.lang.ProcessBuilder(args);
    	var pipe = new jls.io.Pipe();
    	pb.setStdioRedirect(pipe.source(), jls.lang.ProcessBuilder.StandardError);
    	var input = new jls.io.InputStreamReader(pipe.sink());
    	var consoleTA = this._consoleTA;
    	this._process = pb.start();
        this._thread = new jls.lang.Thread(true);
        this._thread.run = function() {
        	var buffer = jls.lang.CharBuffer.allocate(1024);
        	var needLastLineDeletion = false;
            for (;;) {
            	buffer.clear();
            	input.readCharBuffer(buffer);
            	var s = buffer.flip().getString();
                //jls.logger.warn('-->' + s.replace(/\r/g, '\\r').replace(/\n/g, '\\n') + '<--');
            	var lines = s.split('\r');
            	for (var i = 0; i < lines.length; i++) {
            		var line = lines[i];
    				if (needLastLineDeletion) {
                        consoleTA.replaceLastLine('');
                        needLastLineDeletion = false;
    				}
            		//var len = line.length;
            		if (line.charAt(0) == '\n') {
                        consoleTA.appendText('\r' + line);
            		} else {
            			if (i == 0) {
                            consoleTA.appendText(line);
            			} else {
            				if (line.length == 0) {
            					needLastLineDeletion = true;
            				} else {
                                consoleTA.replaceLastLine(line);
            				}
            			}
            		}
            	}
        	}
        };
        jls.logger.debug('Start thread');
        this._thread.start(this);
    }
});

/*Object.extend(spyl.ffgui.FFmpegConsole,
{
});*/

