jls.loader.provide('spyl.ffgui.FFmpegDestination');

jls.loader.require('jls.gui.Panel');
jls.loader.require('jls.gui.Label');
jls.loader.require('jls.gui.Image');
jls.loader.require('jls.gui.Button');
jls.loader.require('jls.gui.CommonDialog');

jls.loader.require('spyl.ffgui.FFmpegConsole');

spyl.ffgui.FFmpegDestination = jls.lang.Class.create({
    initialize : function(launcher) {
    	this._launcher = launcher;
    	this._panel = null;
        this.createPane();
    },
    refreshConfig : function() {
        this._configCB.removeChildren();
        this._formatCB.removeChildren();
        this._videoCodecCB.removeChildren();
        this._audioCodecCB.removeChildren();
        this._configCB.addChildren(Object.keys(this._launcher.getConfig().encodingConfig));
        this._formatCB.addChildren(Object.keys(this._launcher.getConfig().ffConfig.format));
        this._videoCodecCB.addChildren(Object.keys(this._launcher.getConfig().ffConfig.video));
        this._audioCodecCB.addChildren(Object.keys(this._launcher.getConfig().ffConfig.audio));
    },
    refreshSource : function(pr) {
        var videoStream = pr.streamByCodecType.video[0];
        var audioStream = pr.streamByCodecType.audio[0];
        /*
		video:
		 start_time: 0.220011
		 duration: 22.440000
		*/
        this._formatCB.setAttribute('text', pr.format_name);
        this._videoCodecCB.setAttribute('text', videoStream.codec_name);
        this._videoWidthEdit.setAttribute('text', videoStream.width);
        this._videoHeightEdit.setAttribute('text', videoStream.height);
        this._videoDAREdit.setAttribute('text', videoStream.display_aspect_ratio);
        this._audioCodecCB.setAttribute('text', audioStream.codec_name);
        this._audioSampleRateEdit.setAttribute('text', audioStream.sample_rate);
    },
    createPane : function() {
        var panel = new jls.gui.Panel({attributes: {title: 'Destination'}, style: {hGap: 3, vGap: 3}}, this._launcher.getTab());
    	var labelWidth = '160px';
    	var labelHeight = '22px';
        /*
         * TODO Add fields
         * disable audio/video
         * Allow copy codec for audio/video
         */
        new jls.gui.Label({attributes: {text: 'Configuration:'}, style: {width: labelWidth, height: labelHeight}}, panel);
        this._configCB = new jls.gui.ComboBox({style: {width: '2w', height: labelHeight, border: 1}}, panel);
    	var saveConfig = new jls.gui.Button({attributes: {text: 'Save'}, style: {width: '1w', height: labelHeight}}, panel);
    	var loadConfig = new jls.gui.Button({attributes: {text: 'Load'}, style: {width: '1w', height: labelHeight, clear: 'right'}}, panel);
        new jls.gui.Label({attributes: {text: 'File format:'}, style: {width: labelWidth, height: labelHeight}}, panel);
        this._formatCB = new jls.gui.ComboBox({style: {width: '1w', height: labelHeight, border: 1, clear: 'right'}}, panel);
        new jls.gui.Label({attributes: {text: 'Video codec:'}, style: {width: labelWidth, height: labelHeight}}, panel);
        this._videoCodecCB = new jls.gui.ComboBox({style: {width: '1w', height: labelHeight, border: 1, clear: 'right'}}, panel);
        new jls.gui.Label({attributes: {text: 'Size:'}, style: {width: labelWidth, height: labelHeight}}, panel);
        this._videoWidthEdit = new jls.gui.Edit({attributes: {text: ''}, style: {width: '1w', height: labelHeight, border: 1}}, panel);
        new jls.gui.Label({attributes: {text: 'x'}, style: {width: labelHeight, height: labelHeight}}, panel);
        this._videoHeightEdit = new jls.gui.Edit({attributes: {text: ''}, style: {width: '1w', height: labelHeight, border: 1, clear: 'right'}}, panel);
        new jls.gui.Label({attributes: {text: 'Display Aspect Ratio:'}, style: {width: labelWidth, height: labelHeight}}, panel);
        this._videoDAREdit = new jls.gui.Edit({attributes: {text: ''}, style: {width: '1w', height: labelHeight, border: 1, clear: 'right'}}, panel);
        new jls.gui.Label({attributes: {text: 'Audio codec:'}, style: {width: labelWidth, height: labelHeight}}, panel);
        this._audioCodecCB = new jls.gui.ComboBox({style: {width: '1w', height: labelHeight, border: 1, clear: 'right'}}, panel);
        new jls.gui.Label({attributes: {text: 'Sample audio rate:'}, style: {width: labelWidth, height: labelHeight}}, panel);
        this._audioSampleRateEdit = new jls.gui.Edit({attributes: {text: ''}, style: {width: '1w', height: labelHeight, border: 1, clear: 'right'}}, panel);

        new jls.gui.Label({attributes: {text: 'Filename:'}, style: {width: labelWidth, height: labelHeight}}, panel);
    	this._fileEdit = new jls.gui.Edit({attributes: {text: 'test.avi'}, style: {width: '1w', height: labelHeight, border: 1}}, panel);
    	var fileButton = new jls.gui.Button({attributes: {text: '...'}, style: {width: labelHeight, height: labelHeight, clear: 'right'}}, panel);

        new jls.gui.Label({attributes: {text: 'Additional options:'}, style: {width: labelWidth, height: labelHeight, clear: 'right'}}, panel);
        this._optionsEdit = new jls.gui.Edit({attributes: {text: '-sameq'}, style: {width: '1w', height: labelHeight, border: 1, clear: 'right'}}, panel);
        var startButton = new jls.gui.Button({attributes: {text: 'Start'}, style: {width: '1w', height: labelHeight}}, panel);

        //this._configCB.observe('change', this.onChangeConfig.bind(this));
        loadConfig.observe('click', this.onLoadConfig.bind(this));
        saveConfig.observe('click', this.onSaveConfig.bind(this));
        startButton.observe('click', this.onStart.bind(this));
        fileButton.observe('click', this.onFile.bind(this));
        
        this._panel = panel;
    },
    onFile : function(event) {
        var filename = jls.gui.CommonDialog.getSaveFileName(this._panel, true);
        if (! filename) {
            return;
        }
        /*if (new jls.io.File(filename).exists()) {
            jls.lang.System.stdout.println('The file "' + filename + '" already exists');
            return;
        }*/
        this._fileEdit.setAttribute('text', filename);
    },
    onLoadConfig : function(event) {
    	var name = this._configCB.getAttribute('text');
    	if (! (name in this._launcher.getConfig().encodingConfig)) {
    		return;
    	}
        jls.lang.System.out.println('Load encoding configuration "' + name + '"');
    	var config = this._launcher.getConfig().encodingConfig[name];
        this._formatCB.setAttribute('text', config.format);
        this._videoCodecCB.setAttribute('text', config.vcodec);
        this._videoWidthEdit.setAttribute('text', config.width);
        this._videoHeightEdit.setAttribute('text', config.height);
        this._videoDAREdit.setAttribute('text', config.dar);
        this._audioCodecCB.setAttribute('text', config.acodec);
        this._audioSampleRateEdit.setAttribute('text', config.sampleRate);
    },
    onSaveConfig : function(event) {
    	var name = this._configCB.getAttribute('text');
    	this._launcher.getConfig().encodingConfig[name] = {
    			format : this._formatCB.getAttribute('text'),
    			vcodec : this._videoCodecCB.getAttribute('text'),
    			width : this._videoWidthEdit.getAttribute('text'),
    			height : this._videoHeightEdit.getAttribute('text'),
    			dar : this._videoDAREdit.getAttribute('text'),
    			acodec : this._audioCodecCB.getAttribute('text'),
    			sampleRate : this._audioSampleRateEdit.getAttribute('text')
        	};
		this._launcher.onConfigChanged();
        jls.lang.System.out.println('Encoding configuration "' + name + '" updated');
    },
    onStart : function(event) {
    	//var p = new jls.lang.Process([this._launcher.getFFmpeg()._ffmpeg]);
        /*var p = this._launcher.getFFmpeg().start();
        p.setExitCallback(function(exitCode) {
            jls.lang.System.out.println('ffmpeg exit code: ' + exitCode);
        });
        return;*/

        if (this._launcher._sources.length != 1) {
        	return;
        }
        var source = this._launcher._sources[0];
        var filename = this._fileEdit.getAttribute('text');
    	//var filename = jls.gui.CommonDialog.getOpenFileName(this._launcher.getFrame());
        if (! filename) {
            return;
        }
    	var opts = [];
    	//opts.push('-deinterlace');
    	opts.push('-f', this._formatCB.getAttribute('text'));
    	opts.push('-vcodec', this._videoCodecCB.getAttribute('text'));
    	//opts.push('-b', '768k');
    	//opts.push('-async', '0');
    	//opts.push('-passlogfile', 'passlogfile.tmp');
    	opts.push('-acodec', this._audioCodecCB.getAttribute('text'));
    	// For AVI, square (1:1) pixels is the only safe setting.
    	opts.push('-aspect', this._videoDAREdit.getAttribute('text'));
    	//opts.push('-g', '36');
    	//opts.push('-ab', '32k');
    	opts.push('-ar', parseInt(this._audioSampleRateEdit.getAttribute('text'), 10));
    	opts.push('-s', this._videoWidthEdit.getAttribute('text') + 'x' + this._videoHeightEdit.getAttribute('text'));
    	var additionalOptions = this._optionsEdit.getAttribute('text');
    	if (additionalOptions) {
        	opts.push(additionalOptions.split(' '));
    	}
    	var args = this._launcher.getFFmpeg().computeArguments(filename, opts, source.getFilename());
    	var console = new spyl.ffgui.FFmpegConsole(this._launcher, args);
    	
        /*var process = this._launcher.getFFmpeg().start(source.getFilename(), filename, opts);
        //process.detach();
        process.setExitCallback(function(exitCode) {
            jls.lang.System.out.println('ffmpeg exit code: ' + exitCode);
        });*/
    }
});

Object.extend(spyl.ffgui.FFmpegDestination,
{
	options : [{name : '-f', label : 'File format', value : 'flv'},
	           {name : '-b', label : 'Bit rate', value : '768k'},
	           {name : '-aspect', label : 'Aspect', value : '4:3'},
	           {name : '-s', label : 'Size', value : '480x270'},
	           {name : '-vf', label : 'Padding', value : 'pad=480:360:0:44'},
	           {name : '-g', label : 'GOP', value : '36'},
	           {name : '-ab', label : 'Audio bit rate', value : '32k'},
	           {name : '-ar', label : 'Audio frequency', value : '22050'}
	]
});

