jls.loader.provide('spyl.ffgui.FileSource');

jls.loader.require('jls.gui.Panel');
jls.loader.require('jls.gui.Label');
jls.loader.require('jls.gui.Image');
jls.loader.require('jls.gui.Button');
jls.loader.require('jls.gui.Edit');
jls.loader.require('jls.gui.CommonDialog');

jls.loader.require('jls.io.File');

spyl.ffgui.FileSource = jls.lang.Class.create({
    initialize : function(launcher, filename) {
    	this._launcher = launcher;
    	this._panel = null;
    	this._filename = filename;

        jls.lang.System.out.println('Loading "' + this._filename + '"');
        var file = new jls.io.File(this._filename);
        if (! file.isFile()) {
            throw new jls.lang.Exception('File not found');
        }
        this._pr = this._launcher.getFFmpeg().probe(this._filename);
        this.createPane();
        this.refresh();
    },
    createPane : function() {
        var panel = new jls.gui.Panel({attributes: {title: 'Source ' + this._filename}, style: {hGap: 3, vGap: 3}}, this._launcher.getTab());
    	var labelWidth = '160px';
    	var labelHeight = '22px';
        new jls.gui.Label({attributes: {text: 'File format:'}, style: {width: labelWidth, height: labelHeight}}, panel);
        this._formatEdit = new jls.gui.Edit({style: {width: '1w', height: labelHeight, border: 1, clear: 'right'}}, panel);
        new jls.gui.Label({attributes: {text: 'Video codec:'}, style: {width: labelWidth, height: labelHeight}}, panel);
        this._videoCodecEdit = new jls.gui.Edit({style: {width: '1w', height: labelHeight, border: 1, clear: 'right'}}, panel);
        new jls.gui.Label({attributes: {text: 'Size:'}, style: {width: labelWidth, height: labelHeight}}, panel);
        this._videoWidthEdit = new jls.gui.Edit({attributes: {text: ''}, style: {width: '1w', height: labelHeight, border: 1}}, panel);
        new jls.gui.Label({attributes: {text: 'x'}, style: {width: labelHeight, height: labelHeight}}, panel);
        this._videoHeightEdit = new jls.gui.Edit({attributes: {text: ''}, style: {width: '1w', height: labelHeight, border: 1, clear: 'right'}}, panel);
        new jls.gui.Label({attributes: {text: 'Display Aspect Ratio:'}, style: {width: labelWidth, height: labelHeight}}, panel);
        this._videoDAREdit = new jls.gui.Edit({attributes: {text: ''}, style: {width: '1w', height: labelHeight, border: 1, clear: 'right'}}, panel);
        new jls.gui.Label({attributes: {text: 'Audio codec:'}, style: {width: labelWidth, height: labelHeight}}, panel);
        this._audioCodecEdit = new jls.gui.Edit({style: {width: '1w', height: labelHeight, border: 1, clear: 'right'}}, panel);
        new jls.gui.Label({attributes: {text: 'Sample audio rate:'}, style: {width: labelWidth, height: labelHeight}}, panel);
        this._audioSampleRateEdit = new jls.gui.Edit({attributes: {text: ''}, style: {width: '1w', height: labelHeight, border: 1, clear: 'right'}}, panel);
        new jls.gui.Label({attributes: {text: 'Additional options:'}, style: {width: labelWidth, height: labelHeight, clear: 'right'}}, panel);
        this._optionsEdit = new jls.gui.Edit({attributes: {text: ''}, style: {width: '1w', height: labelHeight, border: 1, clear: 'right'}}, panel);
        this._panel = panel;
    },
    refresh : function() {
        var videoStream = this._pr.streamByCodecType.video[0];
        var audioStream = this._pr.streamByCodecType.audio[0];
        this._formatEdit.setAttribute('text', this._pr.format_name);
        this._videoCodecEdit.setAttribute('text', videoStream.codec_name);
        this._videoWidthEdit.setAttribute('text', videoStream.width);
        this._videoHeightEdit.setAttribute('text', videoStream.height);
        this._videoDAREdit.setAttribute('text', videoStream.display_aspect_ratio);
        this._audioCodecEdit.setAttribute('text', audioStream.codec_name);
        this._audioSampleRateEdit.setAttribute('text', audioStream.sample_rate);
    },
    getFilename : function() {
    	return this._filename;
    },
    getProbeResult : function() {
    	return this._pr;
    }
});

/*Object.extend(spyl.ffgui.FileSource,
{
});*/

