jls.loader.provide('spyl.ffgui.Launcher');

jls.loader.require('jls.gui.Frame');
jls.loader.require('jls.gui.Tab');
jls.loader.require('jls.gui.Panel');
jls.loader.require('jls.gui.Label');
jls.loader.require('jls.gui.Edit');
jls.loader.require('jls.gui.Image');
jls.loader.require('jls.gui.Button');
jls.loader.require('jls.gui.ComboBox');
jls.loader.require('jls.gui.MenuItem');
jls.loader.require('jls.gui.CommonDialog');
jls.loader.require('jls.gui.GuiUtilities');
jls.loader.require('jls.io.File');
jls.loader.require('spyl.ffgui.FFmpeg');

jls.loader.require('spyl.ffgui.FFmpegDestination');
jls.loader.require('spyl.ffgui.FileSource');

spyl.ffgui.Launcher = jls.lang.Class.create({
    initialize : function(configFilename) {
    	this._config = null;
    	this._configFilename = configFilename;
    	this._ffmpeg = null;
    	this._frame = null;
    	this._tab = null;
        this._destination = null;
        this._sources = [];

    	this.loadConfig();
        try {
            this.createFFmpeg();
        }
        catch (e) {
            jls.lang.System.out.println(e);
        }
    },
    loadConfig : function() {
    	this._configChanged = false;
    	this._config = null;
        var configFile = new jls.io.File(this._configFilename);
        if (! (configFile.isFile() && (configFile.length() > 0))) {
            // default configuration
        	this._config = {
        			ffHome : 'dep/ffmpeg/bin',
                    encodingConfig : {}
        	};
            this._configChanged = true;
            return;
        }
        var buffer = jls.lang.CharBuffer.allocate(configFile.length() + 1);
        var input = new jls.io.InputStreamReader(new jls.io.FileInputStream(configFile), 'UTF-8');
        input.readCharBuffer(buffer);
        input.close();
        var configJSON = buffer.flip().getString();
        this._config = eval('(' + configJSON + ')');
    },
    saveConfig : function() {
        var configJSON = Object.toJSON(this._config);
        var configFile = new jls.io.File(this._configFilename);
        var output = new jls.io.OutputStreamWriter(new jls.io.FileOutputStream(configFile), 'UTF-8');
        output.write(configJSON);
        output.close();
    },
    onConfigChanged : function() {
        this._configChanged = true;
    },
    getConfig : function() {
        return this._config;
    },
    getFFmpeg : function() {
        return this._ffmpeg;
    },
    getTab : function() {
        return this._tab;
    },
    getFrame : function() {
        return this._frame;
    },
    createFrame : function() {
    	this._frame = new jls.gui.Frame({attributes: {title: 'FFgui', layout: 'jls.gui.CardLayout'}, style: {splitSize: 5, width: 640, height: 480}});
    	this._menu = jls.gui.MenuItem.createMenu();
    	this._fileMenu = new jls.gui.MenuItem({label: 'File', popup: true}, this._menu);
    	//jls.gui.MenuItem.createMenuSeparator(this._fileMenu);
        new jls.gui.MenuItem({label: 'Open...', event: 'open'}, this._fileMenu);
        new jls.gui.MenuItem({label: 'Select FFmpeg...', event: 'selectFFmpeg'}, this._fileMenu);
    	new jls.gui.MenuItem({label: 'Exit', event: 'exit'}, this._fileMenu);
    	this._aboutMenu = new jls.gui.MenuItem({label: '?', popup: true}, this._menu);
    	new jls.gui.MenuItem({label: 'About', event: 'about'}, this._aboutMenu);
    	this._frame.setMenu(this._menu);

        this._tab = new jls.gui.Tab({attributes: {selectOnAdd: true}}, this._frame);

        if (this.getFFmpeg() != null) {
            this._destination = new spyl.ffgui.FFmpegDestination(this);
            this._destination.refreshConfig();
        }

        // register handler
    	this._menu.observe('open', this.onOpen.bind(this));
    	this._menu.observe('selectFFmpeg', this.onSelectFFmpeg.bind(this));
    	this._menu.observe('about', this.onAbout.bind(this));
    	this._menu.observe('exit', this.onExit.bind(this));
        return this._frame;
    },
    onSelectFFmpeg : function(event) {
        var filename = jls.gui.CommonDialog.getOpenFileName();
        if (! filename) {
            return;
        }
        var file = new jls.io.File(filename);
        if (! (file.isFile() && (file.getName() == 'ffmpeg.exe'))) {
            jls.lang.System.err.println('Invalid FFmpeg application: "' + filename + '"');
            return;
        }
        this.getConfig().ffHome = file.getParent();
        try {
            this.createFFmpeg(true);
        }
        catch (e) {
            jls.lang.System.err.println(e);
            return;
        }
        this.onConfigChanged();
        jls.lang.System.out.println('ffHome: "' + this.getConfig().ffHome + '"');
        if (this._destination == null) {
            this._destination = new spyl.ffgui.FFmpegDestination(this);
            this._destination.refreshConfig();
        }
    },
    createFFmpeg : function(forceExtract) {
        this._ffmpeg = new spyl.ffgui.FFmpeg(this.getConfig().ffHome);
        if (forceExtract || (! ('ffConfig' in this.getConfig()))) {
            this.getConfig().ffConfig = spyl.ffgui.Launcher.extractEncoders(this._ffmpeg);
            this.onConfigChanged();
        }
    },
    onOpen : function(event) {
        var filename = jls.gui.CommonDialog.getOpenFileName(this._frame);
        if (! filename) {
            return;
        }
        this.openFilename(filename);
    },
    openFilename : function(filename) {
        var source = new spyl.ffgui.FileSource(this, filename);
        this._sources.push(source);
        
        if ((this._sources.length == 1) && (this._destination != null)) {
            this._destination.refreshSource(source.getProbeResult());
        }
    },
    onAbout : function(event) {
    	var aboutFrame = new jls.gui.Frame({attributes: {title: 'About'}, style: {splitSize: 5, width: 320, height: 240}});
    	var about = 'n/a';
        new jls.gui.Label({attributes: {text: about}, style: {width: '100%', height: 20}}, aboutFrame);
    },
    onExit : function(event) {
    	if (this._configChanged) {
        	this.saveConfig();
            jls.lang.System.out.println('Configuration saved');
    	}
    	if (this._frame == null) {
    		return;
    	}
    	this._frame.onDestroy();
    	this._frame = null;
    }
});

Object.extend(spyl.ffgui.Launcher,
{
	ffmpeg: null,
    ui: null,
    main : function(args) {
    	var configFilename = jls.lang.System.getProperty('spyl.ffgui.configFilename', 'ffgui.json');
        if (jls.lang.System.getArguments().length > 0) {
        	configFilename = jls.lang.System.getArguments()[0];
        }
    	spyl.ffgui.Launcher.ui = new spyl.ffgui.Launcher(configFilename);
    	jls.gui.GuiUtilities.invokeLater(function() {
        	spyl.ffgui.Launcher.ui.createFrame();
        	if (jls.lang.System.getArguments().length > 1) {
                var filename = jls.lang.System.getArguments()[1];
                spyl.ffgui.Launcher.ui.openFilename(filename);
                //spyl.ffgui.Launcher.ui.onExit();
            }
    	});
    },
    extractEncoders : function(ffmpeg) {
        jls.lang.System.out.println('Loading ffmpeg formats...');
        var formats = ffmpeg.extractFormats();
        jls.lang.System.out.println('Loading ffmpeg codecs...');
        var codecs = ffmpeg.extractCodecs();
        var encoder = {
            audio: codecs.audio.encoder,
            video: codecs.video.encoder,
            format: formats.encoder
        };
        /*for (var type in encoder) {
	        jls.lang.System.out.println('Encoder ' + type + ':');
	        for (var name in encoder[type]) {
	            jls.lang.System.out.println(' ' + name + ': ' + Object.toJSON(encoder[type][name]));
	        }
        }*/
        return encoder;
    },
    getFile : function(paths, filename) {
    	var pathList = paths.split(jls.io.File.pathSeparator);
    	for (var i = 0; i < pathList.length; i++) {
    		var file = new jls.io.File(pathList[i] + jls.io.File.separator + filename);
    		//jls.lang.System.out.println('try "' + file.getPath() + '"');
            if (file.isFile()) {
            	return file.getPath();
            }
    	}
    	throw new jls.lang.Exception('Cannot found "' + filename + '"');
    }
});

