jls.loader.require('jls.gui.Frame');
jls.loader.require('jls.gui.Panel');
jls.loader.require('jls.gui.Button');
jls.loader.require('jls.gui.Label');
jls.loader.require('jls.gui.ComboBox');
jls.loader.require('jls.gui.Edit');
jls.loader.require('jls.gui.TextArea');
jls.loader.require('jls.gui.TrayIcon');
jls.loader.require('jls.gui.MenuItem');
jls.loader.require('jls.io.File');
jls.loader.require('jls.io.FileInputStream');
jls.loader.require('jls.io.PrintStream');

var icons = ['res/run.ico', '../res/run.ico'];
var icon = 'run.ico';
for (var i = 0; i < icons.length; i++) {
    if (new jls.io.File(icons[i]).exists()) {
        icon = icons[i];
    }
}

var launchers = {};

// Create popup menu
var trayMenu = jls.gui.MenuItem.createPopupMenu();
var popupMenu = new jls.gui.MenuItem({label: 'Options', popup: true}, trayMenu);
new jls.gui.MenuItem({label: 'Add', event: 'add'}, popupMenu);
new jls.gui.MenuItem({label: 'Modify', event: 'modify'}, popupMenu);
new jls.gui.MenuItem({label: 'Remove', event: 'remove'}, popupMenu);
jls.gui.MenuItem.createMenuSeparator(popupMenu);
new jls.gui.MenuItem({label: 'Configure', event: 'configure'}, popupMenu);
jls.gui.MenuItem.createMenuSeparator(popupMenu);
new jls.gui.MenuItem({label: 'Exit', event: 'exit'}, popupMenu);
jls.gui.MenuItem.createMenuSeparator(trayMenu);

// Create tray icon
var trayIcon = new jls.gui.TrayIcon({attributes: {tip: 'Run', icon: icon}});
trayIcon.observe('dblclick',function(event) {
    // TODO Remove
    trayIcon.onDestroy();
});

// Register UI handlers
trayIcon.observe('click', function(event) {
	if (event.button == jls.gui.Event.MOUSE_BUTTON_RIGHT) {
		trayIcon.trackPopup(trayMenu);
	}
});

var jlsHome = jls.lang.System.getProperty('jls.home');
var jlsProgramName = jls.lang.System.getProperty('jls.programname');
var jlsProgram = jlsHome + jls.io.File.separator + jlsProgramName + '.exe';
var userDir = jls.lang.System.getProperty('user.dir');
var configFilename = userDir + jls.io.File.separator + 'trayicon.json';

var addLauncher = function(name, parameters) {
    launchers[name] = parameters;
    new jls.gui.MenuItem({label: name, event: 'run'}, trayMenu);
};
var modifyLauncher = function(name, parameters) {
    launchers[name] = parameters;
};
var removeLauncher = function(name) {
    delete launchers[name];
    var count = trayMenu.getItemCount();
    for (var index = 0; index < count; index++) {
        var item = trayMenu.getItem(index);
        if (item.getLabel() == name) {
            trayMenu.removeMenuItem(index);
            break;
        }
    }
};

var loadChanges = function() {
    launchers = {};
    var configFile = new jls.io.File(configFilename);
    if (! configFile.isFile()) {
        return;
    }
    if (configFile.length() == 0) {
        return;
    }
    var buffer = jls.lang.ByteBuffer.allocate(configFile.length() + 10);
    var input = new jls.io.FileInputStream(configFile);
    input.read(buffer);
    input.close();
    var configJSON = buffer.flip().getString();
    //jls.lang.System.out.println('loadChanges() configJSON: ' + configJSON);
    var newLaunchers = eval('(' + configJSON + ')');
    for (var name in newLaunchers) {
        addLauncher(name, newLaunchers[name]);
    }
};

var saveChanges = function() {
    var configJSON = Object.toJSON(launchers);
    //jls.lang.System.out.println('saveChanges() configJSON: ' + configJSON);
    var configFile = new jls.io.File(configFilename);
    var output = new jls.io.PrintStream(new jls.io.FileOutputStream(configFile));
    output.println(configJSON);
    output.close();
};

var editLaunchers = function(modificationType) {
	var labelWidth = '100px';//100;
	var editWidth = '2w';//400;
    var frame = new jls.gui.Frame({attributes: {title: modificationType.capitalize(), icon: icon, layout: 'jls.gui.BorderLayout'}, style: {splitSize: 5, width: 640, height: 320}});
    var centerPanel = new jls.gui.Panel({style: {height: 30, region: 'center', textAlign: 'left', verticalAlign: 'top', verticalPosition: 'top', hGap: 3, vGap: 3}}, frame);
    var bottomPanel = new jls.gui.Panel({style: {height: 30, region: 'bottom', textAlign: 'right', verticalAlign: 'middle', verticalPosition: 'middle', hGap: 3, vGap: 3}}, frame);
    var okButton = new jls.gui.Button({attributes: {text: 'Ok'}, style: {width: 80, height: 20}}, bottomPanel);
    var cancelButton = new jls.gui.Button({attributes: {text: 'Cancel'}, style: {width: 80, height: 20}}, bottomPanel);
    cancelButton.observe('click', function(event) {
        frame.onDestroy();
    });
    new jls.gui.Label({attributes: {text: 'Name:'}, style: {width: labelWidth, height: 20}}, centerPanel);
    var nameEdit = null;
    if (modificationType == 'add') {
        nameEdit = new jls.gui.Edit({attributes: {text: 'jls'}, style: {width: editWidth, height: 20, border: 1, clear: 'right'}}, centerPanel);
    } else {
        nameEdit = new jls.gui.ComboBox({children: Object.keys(launchers), style: {width: editWidth, height: 20, border: 1, clear: 'right'}}, centerPanel);
        nameEdit.observe('change', function(event) {
            var name = nameEdit.getText();
            if (! (name in launchers)) {
                return;
            }
            var launcher = launchers[name];
            programEdit.setText(launcher.program);
            directoryEdit.setText(launcher.directory);
            argumentsTextArea.setText(launcher.arguments);
        });
    }
    new jls.gui.Label({attributes: {text: 'Program:'}, style: {width: labelWidth, height: 20}}, centerPanel);
    var programEdit = new jls.gui.Edit({attributes: {text: jlsProgram}, style: {width: editWidth, height: 20, border: 1, clear: 'right'}}, centerPanel);
    new jls.gui.Label({attributes: {text: 'Directory:'}, style: {width: labelWidth, height: 20}}, centerPanel);
    var directoryEdit = new jls.gui.Edit({attributes: {text: jlsHome}, style: {width: editWidth, height: 20, border: 1, clear: 'right'}}, centerPanel);
    new jls.gui.Label({attributes: {text: 'Arguments:'}, style: {width: labelWidth, height: 20}}, centerPanel);
    var argumentsTextArea = new jls.gui.TextArea({style: {width: editWidth, height: 160, border: 1, overflow: 'scroll'}}, centerPanel);
    okButton.observe('click', function(event) {
    	var name = nameEdit.getText();
        switch (modificationType) {
        case 'add':
            if (name in launchers) {
                return;
            }
            var program = programEdit.getText();
            if (! new jls.io.File(program).isFile()) {
                return;
            }
            var dir = directoryEdit.getText();
            if ((dir.length > 0) && (! new jls.io.File(dir).isDirectory())) {
                return;
            }
            addLauncher(name, {
                name: name,
                program: program,
                directory: dir,
                arguments: argumentsTextArea.getText()
            });
            break;
        case 'modify':
            if (! (name in launchers)) {
                return;
            }
            var program = programEdit.getText();
            if (! new jls.io.File(program).isFile()) {
                return;
            }
            var dir = directoryEdit.getText();
            if ((dir.length > 0) && (! new jls.io.File(dir).isDirectory())) {
                return;
            }
            modifyLauncher(name, {
                name: name,
                program: program,
                directory: dir,
                arguments: argumentsTextArea.getText()
            });
            break;
        case 'remove':
            if (! (name in launchers)) {
                return;
            }
            removeLauncher(name);
            break;
        }
        saveChanges();
        frame.onDestroy();
    });
};

var configure = function() {
    if (('frame' in this) && (typeof this.frame == 'object')) {
        this.frame.getStyle().setProperty('visibility', 'visible');
    } else {
        var frame = this.frame = new jls.gui.Frame({attributes: {title: 'TrayIcon', icon: icon, layout: 'jls.gui.BorderLayout'}, style: {splitSize: 5, width: 640, height: 320}}, trayIcon);
        var leftPanel = new jls.gui.Panel({style: {border: true, width: 100, region: 'left', splitter: 'true', layout: 'jls.gui.CardLayout'}}, frame);
        var centerPanel = new jls.gui.Panel({style: {region: 'center', textAlign: 'left', verticalAlign: 'top', verticalPosition: 'top', hGap: 3, vGap: 3}}, frame);
        var bottomPanel = new jls.gui.Panel({style: {height: 30, region: 'bottom', textAlign: 'right', verticalAlign: 'middle', verticalPosition: 'middle', hGap: 3, vGap: 3}}, frame);
        var okButton = new jls.gui.Button({attributes: {text: 'Ok'}, style: {width: 80, height: 20}}, bottomPanel);
        var cancelButton = new jls.gui.Button({attributes: {text: 'Cancel'}, style: {width: 80, height: 20}}, bottomPanel);
        okButton.observe('click', function(event) {
            frame.getStyle().setProperty('visibility', 'hidden');
        });
        cancelButton.observe('click', function(event) {
            frame.getStyle().setProperty('visibility', 'hidden');
        });
    }
};

trayMenu.observe('add', function(event) {
    editLaunchers('add');
});
trayMenu.observe('modify', function(event) {
    editLaunchers('modify');
});
trayMenu.observe('remove', function(event) {
    editLaunchers('remove');
});
trayMenu.observe('configure', function(event) {
    configure();
});
trayMenu.observe('run', function(event) {
    var name = event.menuItem._label;
    var launcher = launchers[name];
    var args = [];
    args.push(launcher.program);
    args = args.concat(launcher.arguments.split(' '));
	jls.logger.info('exec: ' + args.join(' '));
    var pb = new jls.lang.ProcessBuilder(args);
    if (launcher.directory.length > 0) {
    	pb.setCurrentDirectory(new jls.io.File(launcher.directory));
    }
    // fork ?
    var process = pb.start();
    process.detach();
});
trayMenu.observe('exit', function(event) {
    trayIcon.onDestroy();
});

loadChanges();