<?php
//error_reporting(0); // Turn off all error reporting

require_once('util.php');
require_once('user.php');
require_once('media.php');
require_once('comment.php');

function default_initialize($exchange) {
    pb_User::initialize();
    pb_Media::initialize();
    pb_Comment::initializeTable();
    $exchange->done('Photo Blog initialized');
}

$connectRightAttributes = array('requiredRight' => 'connect');
$adminRightAttributes = array('requiredRight' => 'admin');
$readRightAttributes = array('requiredRight' => 'read');
$writeRightAttributes = array('requiredRight' => 'write');
$commentRightAttributes = array('requiredRight' => 'comment');

$server = Helper::getInstance()->getServer();

$server->registerOperation('default_initialize', 'initialize', $adminRightAttributes);
$server->registerOperation('user_create', 'createUser');
$server->registerOperation('user_lostPassword', 'lostUserPassword');
$server->registerOperation('user_changePassword', 'changeUserPassword');
$server->registerOperation('user_delete', 'deleteUser', $adminRightAttributes);
$server->registerOperation('user_activate', 'activateUser');
$server->registerOperation('user_authorize', 'authorizeUser', $adminRightAttributes);
$server->registerOperation('user_modify', 'modifyUser', $connectRightAttributes);
$server->registerOperation('user_list', 'listUsers', $readRightAttributes);
$server->registerOperation('user_get', 'getUser', $connectRightAttributes);
$server->registerOperation('user_authenticate', 'authenticateUser', $connectRightAttributes);
$server->registerOperation('user_sendMail', 'sendMail', $adminRightAttributes);
$server->registerOperation('user_feed', 'feedUser', $adminRightAttributes);

$server->registerOperation('media_add', 'addMedia', $writeRightAttributes);
$server->registerOperation('media_list', 'listMedias', $readRightAttributes);

$server->registerOperation('comment_add', 'addComment', $commentRightAttributes);
$server->registerOperation('comment_list', 'listComment', $readRightAttributes);
$server->registerOperation('comment_listMedias', 'listCommentedMedias', $readRightAttributes);

$server->process();

?>