define([
  'jls/lang/Class',
  'jls/lang/Exception',
  'jls/io/cs/Charset',
  'jls/lang/CharBuffer'
], function (
  Class,
  Exception,
  Charset,
  CharBuffer
) {

var OutputStreamWriter;
OutputStreamWriter = Class.create( /** @lends jls.io.OutputStreamWriter.prototype */
{
    /**
     * Creates a writer.
     * 
     * @param {jls.io.OutputStream} out The underlying byte output stream.
     * @param {String} csn The name of the character set to use.
     * @constructs
     * @class A character writer for byte output stream.
     */
    initialize : function(out, csn) {
        // TODO Check output stream
        this._out = out;
        var charset = csn ? Charset.forName(csn) : Charset.defaultCharset();
        this._encoder = charset.newEncoder();
    },
    getOutputStream : function() {
        return this._out;
    },
    close : function() {
        return this._out.close();
    },
    flush : function() {
        return this._out.flush();
    },
    writeChar : function(c) {
    	// TODO Change this
        return this.write(String.fromCharCode(c));
    },
    writeCharBuffer : function(cb) {
        var bb = this._encoder.encode(cb);
        bb.flip();
        return this._out.write(bb);
    },
    /**
     * Writes a string.
     *
     * @param {String} s The string to write.
     * @returns {Number} the write byte count.
     */
    write : function(s) {
        if (typeof s != 'string') {
            throw new Exception('Invalid argument');
        }
        var cb = CharBuffer.wrap(s);
        return this.writeCharBuffer(cb);
    },
    /**
     * Writes a string.
     *
     * @param {String} s The string to write.
     * @returns {Number} the write byte count.
     */
    writeLine : function(s) {
        if (s) {
            return this.write(s + OutputStreamWriter.separator);
        } else {
            return this.write(OutputStreamWriter.separator);
        }
    }
});

Object.extend(OutputStreamWriter,
{
    separator : _native.core.properties['line.separator']
});


return OutputStreamWriter;
});
