define([
  'jls/lang/Class',
  'jls/lang/Exception',
  'jls/lang/AssertionError',
  'jls/jsunit/TestCase',
  'jls/jsunit/TestResult'
], function (
  Class,
  Exception,
  AssertionError,
  TestCase,
  TestResult
) {

var TestSuite;
TestSuite = Class.create(
{
    initialize : function() {
        this._testCases = [];
    },
    addTest : function(test) {
        this._testCases.push(test);
        return this;
    },
    testCount : function() {
        return this._testCases.length;
    },
    addTestSuite : function(tcClass) {
        if (typeof tcClass == 'string') {
            tcClass = require(tcClass);
        }
        if (typeof tcClass != 'function') {
            throw new Exception('Invalid test case class');
        }
        for (var name in tcClass.prototype) {
            if (! (name.startsWith('test') && (typeof tcClass.prototype[name] == 'function'))) {
                continue;
            }
            this.addTest(new tcClass(name));
        }
        return this;
    },
    run : function(tr) {
        for (var i = 0; i < this._testCases.length; i++) {
            //jls.logger.info('running: ' + jls.loader.getClassname(this._testCases[i]) + '(' + this._testCases[i].getName() + ')');
            tr.run(this._testCases[i]);
        }
    }
});


return TestSuite;
});
