define(['jls/lang/Class', 'jls/security/MessageDigest'], function (Class, MessageDigest) {

var Sha1;
(function () {

/*
 * A JavaScript implementation of the Secure Hash Algorithm, SHA-1, as defined
 * in FIPS 180-1
 * Version 2.2 Copyright Paul Johnston 2000 - 2009.
 * Other contributors: Greg Holt, Andrew Kepert, Ydnar, Lostinet
 * Distributed under the BSD License
 * See http://pajhome.org.uk/crypt/md5 for details.
 */

/*
 * Perform the appropriate triplet combination function for the current iteration
 */
var sha1_ft = function(t, b, c, d) {
  if(t < 20) return (b & c) | ((~b) & d);
  if(t < 40) return b ^ c ^ d;
  if(t < 60) return (b & c) | (b & d) | (c & d);
  return b ^ c ^ d;
};

/*
 * Determine the appropriate additive constant for the current iteration
 */
var sha1_kt = function(t) {
  return (t < 20) ?  1518500249 : (t < 40) ?  1859775393 :
         (t < 60) ? -1894007588 : -899497514;
};

/*
 * Add integers, wrapping at 2^32. This uses 16-bit operations internally to work around bugs in some JS interpreters.
 */
var safe_add = function(x, y) {
  var lsw = (x & 0xFFFF) + (y & 0xFFFF);
  var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
  return (msw << 16) | (lsw & 0xFFFF);
};

/*
 * Bitwise rotate a 32-bit number to the left.
 */
var bit_rol = function(num, cnt) {
  return (num << cnt) | (num >>> (32 - cnt));
};

/*
 * Calculate the SHA-1 of an array of big-endian 32-bits words, and a bit length
 */
var computeArray = function(x, len) {
  /* append padding */
  x[len >> 5] |= 0x80 << (24 - len % 32);
  x[((len + 64 >> 9) << 4) + 15] = len;

  var w = Array(80);
  var a =  1732584193;
  var b = -271733879;
  var c = -1732584194;
  var d =  271733878;
  var e = -1009589776;

  for(var i = 0; i < x.length; i += 16) {
    var olda = a;
    var oldb = b;
    var oldc = c;
    var oldd = d;
    var olde = e;
    for(var j = 0; j < 80; j++) {
      if(j < 16) w[j] = x[i + j];
      else w[j] = bit_rol(w[j-3] ^ w[j-8] ^ w[j-14] ^ w[j-16], 1);
      var t = safe_add(safe_add(bit_rol(a, 5), sha1_ft(j, b, c, d)),
                       safe_add(safe_add(e, w[j]), sha1_kt(j)));
      e = d;
      d = c;
      c = bit_rol(b, 30);
      b = a;
      a = t;
    }
    a = safe_add(a, olda);
    b = safe_add(b, oldb);
    c = safe_add(c, oldc);
    d = safe_add(d, oldd);
    e = safe_add(e, olde);
  }
  return Array(a, b, c, d, e);
};


/*
 * Message digest implementation for SHA1 algorithm.
 */
Sha1 = Class.create(MessageDigest,
{
    initialize : function($super) {
    	$super('SHA1');
    },
    digest : function() {
        this._buffer.flip();
        var length = this._buffer.remaining();
        var wa = [];
        for (var i = 0; this._buffer.remaining() > 0; i++) {
            var b = this._buffer.getByte();
            var m = i % 4
            var d = i >>> 2;
            if (m == 0) {
                wa[d] = 0;
            }
            wa[d] |= b << (24 - (m * 8));
        }
        wa = computeArray(wa, length * 8);
        this._buffer.clear();
        for (var i = 0; i < wa.length; i++) {
            var w = wa[i];
            this._buffer.putByte((w >>> 24) & 0xff);
            this._buffer.putByte((w >>> 16) & 0xff);
            this._buffer.putByte((w >>> 8) & 0xff);
            this._buffer.putByte(w & 0xff);
        }
        this._buffer.flip();
        return this._buffer;
    }
});

// static
MessageDigest.addMessageDigest(Sha1);

})();

return Sha1;
});
