define(['jls/lang/Class'], function (Class) {

var Locale;
Locale = Class.create( /** @lends jls.util.Locale.prototype */
{
    /**
     * Creates an Locale instance.
     * 
     * @param {String} language The language code.
     * @param {String} country The country code.
     * @constructs
     * @class This class provides locale information.
     */
    initialize : function(language, country) {
        this.language = language;
        this.country = country;
    },
    getCountry : function() {
        return this.country;
    },
    getLanguage : function() {
        return this.language;
    },
    toString : function() {
        return this.language + '_' + this.country;
    }
});

Object.extend(Locale, /** @lends jls.util.Locale */
{
    DEFAULT: new Locale(_native.core.properties['user.language'], _native.core.properties['user.region']),
    /**
     * Returns the default Locale instance.
     *
     * @returns {jls.util.Locale} The default Locale instance.
     */
    getDefault : function() {
        return Locale.DEFAULT;
    }
});

return Locale;
});
