define(['jls/lang/Class', 'jls/util/XmlElement'], function (Class, XmlElement) {

var SxeEnvelope;
SxeEnvelope = Class.create(XmlElement, /** @lends jls.util.SxeEnvelope.prototype */
{
    /**
     * Creates an SXE Envelope.
     * 
     * @param {String} [login] The authentication login.
     * @param {String} [password] The authentication password.
     * @constructs
	 * @class This class represents an SXE Envelope.
     */
    initialize : function($super, login, password) {
    	/*if (typeof login == 'object') {
    		$super(login);
    		return;
    	}*/
		$super({name: 'envelope'});
    	this._header = this.addChild({name: 'header'});
    	this._body = this.addChild({name: 'body'});
    	if (login && password) {
    		this.setAuthentication(login, password);
    	}
    },
    getHeader : function() {
        return this._header;
    },
    getBody : function() {
        return this._body;
    },
    /**
     * Sets the authentication credential for this envelope.
     *
     * @param {String} login The authentication login.
     * @param {String} password The authentication password.
     */
    setAuthentication : function(login, password) {
    	this._header.removeChildren();
    	//this._header.addChild({name: 'authentication', attributes: {login: login, password: password}});
    	this._header.addChild({name: 'authentication',
    		children: [{name: 'login', value: login}, {name: 'password', value: password}]});
    	return this;
    },
    /**
     * Adds a request to this envelope.
     *
     * @param {jls.util.XmlElement} request The request to add.
     */
    addRequest : function(request) {
    	this._body.addChild(request);
    	return this;
    },
    /**
     * Adds a reply to this envelope.
     *
     * @param {jls.util.XmlElement} reply The reply to add.
     */
    reply : function(reply) {
        this._body.addChild(reply);
        return this;
    },
    fail : function(message, id) {
        var reply = {name: 'failure'};
        if (typeof message != 'undefined') {
            reply.message = message;
        }
        if (typeof id != 'undefined') {
            reply.id = id;
        }
        this._body.addChild(reply);
        return this;
    },
    getResult : function(index) {
        return this._body.getChild(index);
    }
});

Object.extend(SxeEnvelope, /** @lends jls.util.SxeEnvelope */
{
    /**
     * Creates an SXE envelope base on the specidied DOM node.
     * 
     * @param {Object} domNode The DOM node to parse.
     * @returns {jls.util.SxeEnvelope} The SXE envelope.
     */
    createFromDOM : function(domNode) {
    	var envelope = new SxeEnvelope();
    	envelope.removeChildren();
    	XmlElement.populateFromDOM(envelope, domNode);
    	envelope._header = envelope.getChild(0);
    	envelope._body = envelope.getChild(1);
    	return envelope;
    },
    /**
     * Creates an SXE envelope base on the specidied E4X node.
     * 
     * @param {Object} domNode The E4X node to parse.
     * @returns {jls.util.SxeEnvelope} The SXE envelope.
     */
    createFromE4X : function(xmlNode) {
        var envelope = new SxeEnvelope();
        envelope.removeChildren();
        XmlElement.populateFromE4X(envelope, xmlNode);
        envelope._header = envelope.getChild(0);
        envelope._body = envelope.getChild(1);
        return envelope;
    }
});


return SxeEnvelope;
});
