<html>
<head>
<title>PhotoBlog - Setup</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
</head>
<body>
<h1>Configuration</h1>
<form action="setup.php" method="post">
<?php

$baseVariables = array(
    'DB_HOST' => '127.0.0.1',
    'DB_USER' => 'jls',
    'DB_PASSWORD' => 'jls',
    'DB_NAME' => 'jls',
    'DB_PREFIX' => 'PB_',
    'ADMIN_EMAIL' => 'admin@localhost',
    'SITE_NAME' => 'Photo Blog',
    'SITE_ADDRESS' => 'http://localhost:8888/',
    'SITE_PATH' => '',
    'PB_LANGUAGE' => 'en',
);
$extVariables = array(
    'PB_PATH' => "'../'",
    'SCRIPTS_PATH' => "'script'",
    'PRIVATE_PATH' => "'private'",
    'INCOMING_PATH' => "'incoming'",
    'USER_HTPASSWD_FILE' => "'.htpasswd'",
    'PRIVATE_ACCESS_FILE' => "'access.php'",
    'SITE_FULL_ADDRESS' => "SITE_ADDRESS . SITE_PATH",
    'PB_PRIVATE_PATH' => "PB_PATH . PRIVATE_PATH",
    'PB_INCOMING_PATH' => "PB_PATH . INCOMING_PATH",
    'USER_HTPASSWD' => "PB_PRIVATE_PATH . '/' . USER_HTPASSWD_FILE",
    'PRIVATE_ACCESS' => "PB_PRIVATE_PATH . '/' . PRIVATE_ACCESS_FILE"
);

$action = NULL;
if (array_key_exists("action", $_POST)) {
    $action = $_POST["action"];
}
switch ($action) {
case "create":
    $userVariables = array();
    foreach (array_keys($baseVariables) as $field) {
        if (array_key_exists($field, $_POST)) {
            $userVariables[$field] = "'" . $_POST[$field] . "'";
        } else {
            $userVariables[$field] = "'" . $baseVariables[$field] . "'";
        }
    }
    $variables = array_merge($userVariables, $extVariables);
    $file = fopen("globals.php", "w");
    fwrite($file, "<?php\n");
    foreach ($variables as $key => $value) {
        fwrite($file, "define('" . $key . "', " . $value . ");\n");
    }
    fwrite($file, "?>\n");
    fclose($file);

    //error_reporting(0); // Turn off all error reporting
    require_once('util.php');
    require_once('user.php');
    require_once('media.php');
    require_once('comment.php');

    Helper::mkdir(PB_PRIVATE_PATH);
    Helper::mkdir(PB_INCOMING_PATH);
    
    pb_User::initialize();
    pb_Media::initialize();
    pb_Comment::initializeTable();
?>
<p>Photo Blog initialized</p>
<p>You could log as admin/changeit or guest/guest</p>
<?php
    echo '<a href="' . SITE_FULL_ADDRESS . '">click here to access</a><br>' . "\n";
    break;
default:
?>
<table>
<?php
    foreach ($baseVariables as $key => $value) {
        echo '<tr><td><label>' . $key . '</label></td><td><input type="text" name="' . $key . '" value="' . $value . '"></td></tr>' . "\n";
    }
?>
</table>
<input type=submit name="action" value="create">
<?php
    break;
}
?>
</form>
</body>
</html>
